/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.network.packet;

import com.mojang.serialization.Codec;
import com.talkie.walkie.item.WalkieTalkieItem;
import com.talkie.walkie.network.packet.ReceiveVoiceDataPacket;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record VoiceDataPacket(UUID senderId, byte[] audioData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<VoiceDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"talkiewalkie", (String)"voice_data"));
    public static final StreamCodec<ByteBuf, VoiceDataPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)UUIDUtil.CODEC), VoiceDataPacket::senderId, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, VoiceDataPacket::audioData, VoiceDataPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(VoiceDataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sender = (ServerPlayer)patt0$temp;
                ItemStack mainHand = sender.getMainHandItem();
                ItemStack offHand = sender.getOffhandItem();
                double senderFrequency = 0.0;
                if (mainHand.getItem() instanceof WalkieTalkieItem && WalkieTalkieItem.hasFrequency(mainHand)) {
                    senderFrequency = WalkieTalkieItem.getFrequency(mainHand);
                } else if (offHand.getItem() instanceof WalkieTalkieItem && WalkieTalkieItem.hasFrequency(offHand)) {
                    senderFrequency = WalkieTalkieItem.getFrequency(offHand);
                }
                if (senderFrequency > 0.0) {
                    double frequency = senderFrequency;
                    sender.server.getPlayerList().getPlayers().forEach(player -> {
                        if (!player.getUUID().equals(sender.getUUID())) {
                            ItemStack playerMain = player.getMainHandItem();
                            ItemStack playerOff = player.getOffhandItem();
                            double playerFrequency = 0.0;
                            if (playerMain.getItem() instanceof WalkieTalkieItem && WalkieTalkieItem.hasFrequency(playerMain)) {
                                playerFrequency = WalkieTalkieItem.getFrequency(playerMain);
                            } else if (playerOff.getItem() instanceof WalkieTalkieItem && WalkieTalkieItem.hasFrequency(playerOff)) {
                                playerFrequency = WalkieTalkieItem.getFrequency(playerOff);
                            }
                            if (Math.abs(playerFrequency - frequency) < 0.01) {
                                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ReceiveVoiceDataPacket(sender.getUUID(), packet.audioData()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }
                        }
                    });
                }
            }
        });
    }
}

