/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.network.packet;

import com.mojang.serialization.Codec;
import com.talkie.walkie.client.ClientVoiceHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncTalkingStatePacket(UUID playerId, boolean isTalking) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncTalkingStatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"talkiewalkie", (String)"sync_talking_state"));
    public static final StreamCodec<ByteBuf, SyncTalkingStatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)UUIDUtil.CODEC), SyncTalkingStatePacket::playerId, (StreamCodec)ByteBufCodecs.BOOL, SyncTalkingStatePacket::isTalking, SyncTalkingStatePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncTalkingStatePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientVoiceHandler.setPlayerTalking(packet.playerId(), packet.isTalking()));
    }
}

