/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.network.packet;

import com.mojang.serialization.Codec;
import com.talkie.walkie.item.WalkieTalkieItem;
import com.talkie.walkie.network.packet.PlayWalkieBeepPacket;
import com.talkie.walkie.network.packet.SyncTalkingStatePacket;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record StartTalkingPacket(UUID playerId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StartTalkingPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"talkiewalkie", (String)"start_talking"));
    public static final StreamCodec<ByteBuf, StartTalkingPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)UUIDUtil.CODEC), StartTalkingPacket::playerId, StartTalkingPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(StartTalkingPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sender = (ServerPlayer)patt0$temp;
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncTalkingStatePacket(packet.playerId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ItemStack walkieTalkie = sender.getMainHandItem();
                if (walkieTalkie.isEmpty()) {
                    walkieTalkie = sender.getOffhandItem();
                }
                if (!walkieTalkie.isEmpty() && walkieTalkie.getItem() instanceof WalkieTalkieItem) {
                    double senderFrequency = WalkieTalkieItem.getFrequency(walkieTalkie);
                    for (ServerPlayer player : sender.getServer().getPlayerList().getPlayers()) {
                        double playerFrequency;
                        ItemStack playerWalkie = player.getMainHandItem();
                        if (playerWalkie.isEmpty()) {
                            playerWalkie = player.getOffhandItem();
                        }
                        if (playerWalkie.isEmpty() || !(playerWalkie.getItem() instanceof WalkieTalkieItem) || !(Math.abs(senderFrequency - (playerFrequency = WalkieTalkieItem.getFrequency(playerWalkie))) < 0.01)) continue;
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlayWalkieBeepPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            }
        });
    }
}

