/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.network.packet;

import com.talkie.walkie.item.WalkieTalkieItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetFrequencyPacket(double frequency) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetFrequencyPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"talkiewalkie", (String)"set_frequency"));
    public static final StreamCodec<ByteBuf, SetFrequencyPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, SetFrequencyPacket::frequency, SetFrequencyPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetFrequencyPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            ItemStack mainHand = player.getMainHandItem();
            ItemStack offHand = player.getOffhandItem();
            if (mainHand.getItem() instanceof WalkieTalkieItem) {
                WalkieTalkieItem.setFrequency(mainHand, packet.frequency());
                player.displayClientMessage((Component)Component.translatable((String)"message.talkiewalkie.frequency_set", (Object[])new Object[]{String.format("%.1f", packet.frequency())}), true);
            } else if (offHand.getItem() instanceof WalkieTalkieItem) {
                WalkieTalkieItem.setFrequency(offHand, packet.frequency());
                player.displayClientMessage((Component)Component.translatable((String)"message.talkiewalkie.frequency_set", (Object[])new Object[]{String.format("%.1f", packet.frequency())}), true);
            }
        });
    }
}

