/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.network.packet;

import com.mojang.serialization.Codec;
import com.talkie.walkie.audio.VoiceManager;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ReceiveVoiceDataPacket(UUID senderId, byte[] audioData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ReceiveVoiceDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"talkiewalkie", (String)"receive_voice_data"));
    public static final StreamCodec<ByteBuf, ReceiveVoiceDataPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)UUIDUtil.CODEC), ReceiveVoiceDataPacket::senderId, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, ReceiveVoiceDataPacket::audioData, ReceiveVoiceDataPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ReceiveVoiceDataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (Minecraft.getInstance().player != null) {
                VoiceManager.getInstance().playAudio(packet.senderId(), packet.audioData());
            }
        });
    }
}

