/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.network;

import com.talkie.walkie.network.packet.OpenFrequencyScreenPacket;
import com.talkie.walkie.network.packet.PlayWalkieBeepPacket;
import com.talkie.walkie.network.packet.ReceiveVoiceDataPacket;
import com.talkie.walkie.network.packet.SetFrequencyPacket;
import com.talkie.walkie.network.packet.StartTalkingPacket;
import com.talkie.walkie.network.packet.StopTalkingPacket;
import com.talkie.walkie.network.packet.SyncTalkingStatePacket;
import com.talkie.walkie.network.packet.VoiceDataPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="talkiewalkie", bus=EventBusSubscriber.Bus.MOD)
public class NetworkHandler {
    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(SetFrequencyPacket.TYPE, SetFrequencyPacket.STREAM_CODEC, SetFrequencyPacket::handle);
        registrar.playToServer(VoiceDataPacket.TYPE, VoiceDataPacket.STREAM_CODEC, VoiceDataPacket::handle);
        registrar.playToServer(StartTalkingPacket.TYPE, StartTalkingPacket.STREAM_CODEC, StartTalkingPacket::handle);
        registrar.playToServer(StopTalkingPacket.TYPE, StopTalkingPacket.STREAM_CODEC, StopTalkingPacket::handle);
        registrar.playToClient(OpenFrequencyScreenPacket.TYPE, OpenFrequencyScreenPacket.STREAM_CODEC, OpenFrequencyScreenPacket::handle);
        registrar.playToClient(ReceiveVoiceDataPacket.TYPE, ReceiveVoiceDataPacket.STREAM_CODEC, ReceiveVoiceDataPacket::handle);
        registrar.playToClient(SyncTalkingStatePacket.TYPE, SyncTalkingStatePacket.STREAM_CODEC, SyncTalkingStatePacket::handle);
        registrar.playToClient(PlayWalkieBeepPacket.TYPE, PlayWalkieBeepPacket.STREAM_CODEC, PlayWalkieBeepPacket::handle);
    }

    public static void sendToServer(Object packet) {
        if (packet instanceof CustomPacketPayload) {
            CustomPacketPayload payload = (CustomPacketPayload)packet;
            PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToClient(Object packet, ServerPlayer player) {
        if (packet instanceof CustomPacketPayload) {
            CustomPacketPayload payload = (CustomPacketPayload)packet;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToAllClients(Object packet) {
        if (packet instanceof CustomPacketPayload) {
            CustomPacketPayload payload = (CustomPacketPayload)packet;
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

