/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.item;

import com.talkie.walkie.network.NetworkHandler;
import com.talkie.walkie.network.packet.OpenFrequencyScreenPacket;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class WalkieTalkieItem
extends Item {
    public WalkieTalkieItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToClient(new OpenFrequencyScreenPacket(), serverPlayer);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty() && customData.contains("Frequency")) {
            double frequency = customData.copyTag().getDouble("Frequency");
            tooltipComponents.add((Component)Component.translatable((String)"item.talkiewalkie.walkie_talkie.frequency", (Object[])new Object[]{String.format("%.1f", frequency)}));
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"item.talkiewalkie.walkie_talkie.no_frequency"));
    }

    public static double getFrequency(ItemStack stack) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty() && customData.contains("Frequency")) {
            return customData.copyTag().getDouble("Frequency");
        }
        return 0.0;
    }

    public static void setFrequency(ItemStack stack, double frequency) {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("Frequency", frequency);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static boolean hasFrequency(ItemStack stack) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty() && customData.contains("Frequency")) {
            return customData.copyTag().getDouble("Frequency") > 0.0;
        }
        return false;
    }
}

