/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.client.gui;

import com.talkie.walkie.network.NetworkHandler;
import com.talkie.walkie.network.packet.SetFrequencyPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class FrequencyScreen
extends Screen {
    private EditBox frequencyInput;
    private static final int PANEL_WIDTH = 200;
    private static final int PANEL_HEIGHT = 100;

    public FrequencyScreen() {
        super((Component)Component.translatable((String)"gui.talkiewalkie.frequency_screen.title"));
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.frequencyInput = new EditBox(this.font, centerX - 90, centerY - 20, 180, 20, (Component)Component.translatable((String)"gui.talkiewalkie.frequency_input"));
        this.frequencyInput.setMaxLength(5);
        this.frequencyInput.setValue("88.0");
        this.addRenderableWidget((GuiEventListener)this.frequencyInput);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.talkiewalkie.frequency_screen.confirm"), button -> this.setFrequency()).bounds(centerX - 50, centerY + 10, 100, 20).build());
    }

    private void setFrequency() {
        try {
            double frequency = Double.parseDouble(this.frequencyInput.getValue());
            if (frequency >= 80.0 && frequency <= 120.0) {
                NetworkHandler.sendToServer(new SetFrequencyPacket(frequency));
                this.onClose();
            } else {
                this.frequencyInput.setValue("88.0");
            }
        }
        catch (NumberFormatException e) {
            this.frequencyInput.setValue("88.0");
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        graphics.fill(centerX - 100, centerY - 50, centerX + 100, centerY + 50, -1442840576);
        graphics.drawCenteredString(this.font, this.title, centerX, centerY - 40, 0xFFFFFF);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.talkiewalkie.frequency_screen.instructions"), centerX, centerY - 50, 0xAAAAAA);
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

