/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.client;

import com.talkie.walkie.client.ClientVoiceHandler;
import com.talkie.walkie.item.WalkieTalkieItem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class WalkieTalkieHUD
implements LayeredDraw.Layer {
    private static final ResourceLocation MICROPHONE_ICON = ResourceLocation.fromNamespaceAndPath((String)"talkiewalkie", (String)"textures/gui/microphone.png");

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        ItemStack walkieTalkie = null;
        if (mainHand.getItem() instanceof WalkieTalkieItem) {
            walkieTalkie = mainHand;
        } else if (offHand.getItem() instanceof WalkieTalkieItem) {
            walkieTalkie = offHand;
        }
        if (walkieTalkie != null && WalkieTalkieItem.hasFrequency(walkieTalkie)) {
            double frequency = WalkieTalkieItem.getFrequency(walkieTalkie);
            int screenWidth = mc.getWindow().getGuiScaledWidth();
            int screenHeight = mc.getWindow().getGuiScaledHeight();
            String frequencyText = String.format("%.1f MHz", frequency);
            int textWidth = mc.font.width(frequencyText);
            graphics.drawString(mc.font, frequencyText, screenWidth - textWidth - 10, screenHeight - 20, 65280, true);
            if (ClientVoiceHandler.isPlayerTalking(player.getUUID())) {
                graphics.blit(MICROPHONE_ICON, screenWidth - 30, screenHeight - 40, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
    }
}

