/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.client;

import com.talkie.walkie.audio.VoiceManager;
import com.talkie.walkie.network.NetworkHandler;
import com.talkie.walkie.network.packet.StartTalkingPacket;
import com.talkie.walkie.network.packet.StopTalkingPacket;
import com.talkie.walkie.network.packet.VoiceDataPacket;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@EventBusSubscriber(modid="talkiewalkie", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class KeyBindings {
    public static final KeyMapping TALK_KEY = new KeyMapping("key.talkiewalkie.talk", 86, "key.categories.talkiewalkie");
    private static boolean wasTalkingLastTick = false;

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(TALK_KEY);
    }

    @EventBusSubscriber(modid="talkiewalkie", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            byte[] audioData;
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            boolean isTalking = TALK_KEY.isDown();
            if (isTalking && !wasTalkingLastTick) {
                NetworkHandler.sendToServer(new StartTalkingPacket(mc.player.getUUID()));
                VoiceManager.getInstance().startRecording();
            } else if (!isTalking && wasTalkingLastTick) {
                NetworkHandler.sendToServer(new StopTalkingPacket(mc.player.getUUID()));
                VoiceManager.getInstance().stopRecording();
            } else if (isTalking && (audioData = VoiceManager.getInstance().getAudioData()) != null && audioData.length > 0) {
                NetworkHandler.sendToServer(new VoiceDataPacket(mc.player.getUUID(), audioData));
            }
            wasTalkingLastTick = isTalking;
        }
    }
}

