/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.audio;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class VoiceManager {
    private static VoiceManager instance;
    private TargetDataLine microphone;
    private SourceDataLine speaker;
    private boolean isRecording = false;
    private ByteArrayOutputStream audioBuffer;
    private final Map<UUID, ConcurrentLinkedQueue<byte[]>> audioQueues = new HashMap<UUID, ConcurrentLinkedQueue<byte[]>>();
    private final Map<UUID, Thread> playbackThreads = new HashMap<UUID, Thread>();
    private static final AudioFormat AUDIO_FORMAT;
    private static final int BUFFER_SIZE = 2048;
    private static final int PACKET_SIZE = 1024;

    private VoiceManager() {
        try {
            DataLine.Info micInfo = new DataLine.Info(TargetDataLine.class, AUDIO_FORMAT);
            DataLine.Info speakerInfo = new DataLine.Info(SourceDataLine.class, AUDIO_FORMAT);
            if (AudioSystem.isLineSupported(micInfo)) {
                this.microphone = (TargetDataLine)AudioSystem.getLine(micInfo);
            }
            if (AudioSystem.isLineSupported(speakerInfo)) {
                this.speaker = (SourceDataLine)AudioSystem.getLine(speakerInfo);
            }
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public static VoiceManager getInstance() {
        if (instance == null) {
            instance = new VoiceManager();
        }
        return instance;
    }

    public void startRecording() {
        if (this.microphone == null || this.isRecording) {
            return;
        }
        try {
            this.audioBuffer = new ByteArrayOutputStream();
            this.microphone.open(AUDIO_FORMAT, 16384);
            this.microphone.start();
            this.isRecording = true;
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void stopRecording() {
        if (!this.isRecording) {
            return;
        }
        this.isRecording = false;
        if (this.microphone != null) {
            this.microphone.stop();
            this.microphone.close();
        }
    }

    public byte[] getAudioData() {
        if (!this.isRecording || this.microphone == null) {
            return new byte[0];
        }
        int available = this.microphone.available();
        if (available <= 0) {
            return new byte[0];
        }
        int readSize = Math.min(Math.max(available, 1024), 2048);
        byte[] buffer = new byte[readSize];
        int bytesRead = this.microphone.read(buffer, 0, buffer.length);
        if (bytesRead > 0) {
            byte[] data = new byte[bytesRead];
            System.arraycopy(buffer, 0, data, 0, bytesRead);
            return data;
        }
        return new byte[0];
    }

    public void playAudio(UUID senderId, byte[] audioData) {
        if (this.speaker == null || audioData == null || audioData.length == 0) {
            return;
        }
        this.audioQueues.putIfAbsent(senderId, new ConcurrentLinkedQueue());
        ConcurrentLinkedQueue<byte[]> queue = this.audioQueues.get(senderId);
        queue.offer(audioData);
        if (!this.playbackThreads.containsKey(senderId) || !this.playbackThreads.get(senderId).isAlive()) {
            Thread playbackThread = new Thread(() -> {
                try {
                    SourceDataLine playerLine = AudioSystem.getSourceDataLine(AUDIO_FORMAT);
                    playerLine.open(AUDIO_FORMAT, 32768);
                    playerLine.start();
                    long lastDataTime = System.currentTimeMillis();
                    while (!queue.isEmpty() || System.currentTimeMillis() - lastDataTime < 1000L) {
                        byte[] data = (byte[])queue.poll();
                        if (data != null && data.length > 0) {
                            playerLine.write(data, 0, data.length);
                            lastDataTime = System.currentTimeMillis();
                            continue;
                        }
                        Thread.sleep(10L);
                    }
                    playerLine.drain();
                    playerLine.close();
                    this.playbackThreads.remove(senderId);
                    this.audioQueues.remove(senderId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.playbackThreads.remove(senderId);
                    this.audioQueues.remove(senderId);
                }
            });
            playbackThread.setDaemon(true);
            playbackThread.setPriority(10);
            this.playbackThreads.put(senderId, playbackThread);
            playbackThread.start();
        }
    }

    public void cleanup() {
        this.stopRecording();
        for (Thread thread : this.playbackThreads.values()) {
            if (thread == null || !thread.isAlive()) continue;
            thread.interrupt();
        }
        this.playbackThreads.clear();
        this.audioQueues.clear();
        if (this.speaker != null && this.speaker.isOpen()) {
            this.speaker.drain();
            this.speaker.close();
        }
    }

    static {
        AUDIO_FORMAT = new AudioFormat(16000.0f, 16, 1, true, false);
    }
}

