/*
 * Decompiled with CFR 0.152.
 */
package com.talkie.walkie.audio;

import java.util.Random;

public class AudioFilter {
    private static final Random RANDOM = new Random();
    private static final float SAMPLE_RATE = 16000.0f;
    private static final float LOW_FREQ = 300.0f;
    private static final float HIGH_FREQ = 3000.0f;
    private float[] inputHistory = new float[3];
    private float[] outputHistory = new float[3];
    private final float a0;
    private final float a1;
    private final float a2;
    private final float b1;
    private final float b2;

    public AudioFilter() {
        float lowOmega = 0.11780973f;
        float highOmega = 1.1780972f;
        float bandwidth = highOmega - lowOmega;
        float centerFreq = (float)Math.sqrt(lowOmega * highOmega);
        float q = centerFreq / bandwidth;
        float k = (float)Math.tan((double)centerFreq / 2.0);
        float norm = 1.0f / (1.0f + k / q + k * k);
        this.a0 = k / q * norm;
        this.a1 = 0.0f;
        this.a2 = -this.a0;
        this.b1 = 2.0f * (k * k - 1.0f) * norm;
        this.b2 = (1.0f - k / q + k * k) * norm;
    }

    public byte[] applyWalkieTalkieEffect(byte[] audioData) {
        if (audioData == null || audioData.length == 0) {
            return audioData;
        }
        byte[] filtered = new byte[audioData.length];
        for (int i = 0; i < audioData.length - 1; i += 2) {
            short sample = (short)(audioData[i + 1] << 8 | audioData[i] & 0xFF);
            float normalized = (float)sample / 32768.0f;
            normalized = this.applyBandpassFilter(normalized);
            normalized = this.softClip(normalized * 1.3f);
            short output = (short)(Math.max(-1.0f, Math.min(1.0f, normalized += (RANDOM.nextFloat() - 0.5f) * 0.02f)) * 32767.0f);
            filtered[i] = (byte)(output & 0xFF);
            filtered[i + 1] = (byte)(output >> 8 & 0xFF);
        }
        return filtered;
    }

    private float applyBandpassFilter(float input) {
        float output = this.a0 * input + this.a1 * this.inputHistory[0] + this.a2 * this.inputHistory[1] - this.b1 * this.outputHistory[0] - this.b2 * this.outputHistory[1];
        this.inputHistory[1] = this.inputHistory[0];
        this.inputHistory[0] = input;
        this.outputHistory[1] = this.outputHistory[0];
        this.outputHistory[0] = output;
        return output;
    }

    private float softClip(float sample) {
        if (sample > 1.0f) {
            return 0.6666667f + (sample - 1.0f) / 3.0f;
        }
        if (sample < -1.0f) {
            return -0.6666667f + (sample + 1.0f) / 3.0f;
        }
        return sample - sample * sample * sample / 3.0f;
    }

    public void reset() {
        this.inputHistory = new float[3];
        this.outputHistory = new float[3];
    }
}

