/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.inventories;

import net.mehvahdjukaar.moonlight.api.misc.IContainerProvider;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.supplementaries.common.block.tiles.AbstractPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.DelegatingSlot;
import net.mehvahdjukaar.supplementaries.reg.ModMenuTypes;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PresentContainerMenu
extends AbstractContainerMenu
implements IContainerProvider {
    @Nullable
    protected final AbstractPresentBlockTile inventory;

    public AbstractPresentBlockTile getContainer() {
        return this.inventory;
    }

    public PresentContainerMenu(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (AbstractPresentBlockTile)TileOrEntityTarget.read((FriendlyByteBuf)packetBuffer).getBlockEntityOrThrow(playerInventory.player.level(), ModRegistry.PRESENT_TILE.get()));
    }

    public <T extends PresentContainerMenu> PresentContainerMenu(int id, Inventory playerInventory, AbstractPresentBlockTile inventory) {
        this(ModMenuTypes.PRESENT_BLOCK.get(), id, playerInventory, inventory);
    }

    public <T extends PresentContainerMenu> PresentContainerMenu(MenuType<T> type, int id, Inventory playerInventory, AbstractPresentBlockTile inventory) {
        super(type, id);
        int si;
        this.inventory = inventory;
        if (inventory == null) {
            return;
        }
        PresentContainerMenu.checkContainerSize((Container)this.inventory, (int)1);
        this.inventory.startOpen(playerInventory.player);
        this.addSlot(new DelegatingSlot((Container)this.inventory, 0, this.getSlotX(), this.getSlotY(), this));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)playerInventory, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)playerInventory, si, 8 + si * 18, 142));
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.inventory != null && this.inventory.stillValid(playerIn);
    }

    protected int getSlotY() {
        return 20;
    }

    protected int getSlotX() {
        return 17;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack item = slot.getItem();
            itemCopy = item.copy();
            if (index < this.inventory.getContainerSize() ? !this.moveItemStackTo(item, this.inventory.getContainerSize(), this.slots.size(), true) : this.moveItemStackTo(item, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (item.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (item.getCount() == itemCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, item);
        }
        return itemCopy;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.inventory.stopOpen(playerIn);
        if (!this.inventory.canHoldItems() && !this.inventory.isRemoved()) {
            this.clearContainer(playerIn, (Container)this.inventory);
        }
    }
}

