/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.util;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.pbj.client.GunClientState;
import mod.pbj.crafting.PointBlankIngredient;
import mod.pbj.item.GunItem;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InventoryUtils {
    public static Tuple<ItemStack, GunClientState> getItemStackByStateId(Player player, UUID gunStateId, int slotIndex) {
        GunClientState gunClientState;
        boolean isOffhand;
        ItemStack targetStack = null;
        GunClientState targetGunState = null;
        ItemStack itemStack = player.getInventory().getItem(slotIndex);
        boolean bl = isOffhand = player.getOffhandItem() == itemStack;
        if (itemStack.getItem() instanceof GunItem && (gunClientState = GunClientState.getState(player, itemStack, slotIndex, isOffhand)) != null && Objects.equals(GunItem.getItemStackId(itemStack), gunStateId)) {
            targetStack = itemStack;
            targetGunState = gunClientState;
        }
        return targetStack != null ? new Tuple(targetStack, targetGunState) : null;
    }

    public static boolean hasIngredient(Player player, PointBlankIngredient ingredient) {
        return player.getInventory().items.stream().filter(ingredient::matches).collect(Collectors.summarizingInt(ItemStack::getCount)).getSum() >= (long)ingredient.getCount();
    }

    public static boolean removeItem(Player player, Predicate<ItemStack> matchingPredicate, int count) {
        Inventory inventory = player.getInventory();
        int remainingCount = count;
        for (int i = 0; i < player.getInventory().items.size(); ++i) {
            ItemStack inventoryItem = (ItemStack)inventory.items.get(i);
            if (!matchingPredicate.test(inventoryItem)) continue;
            int availableCount = inventoryItem.getCount();
            if (availableCount <= remainingCount) {
                remainingCount -= availableCount;
                inventory.items.set(i, (Object)ItemStack.EMPTY);
            } else {
                inventoryItem.shrink(remainingCount);
                remainingCount = 0;
            }
            ((ServerPlayer)inventory.player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, i, inventory.getItem(i)));
            if (remainingCount == 0) break;
        }
        return remainingCount <= 0;
    }

    public static int addItem(Player player, Item item, int count) {
        int i;
        Inventory inventory = player.getInventory();
        ItemStack stackToAdd = new ItemStack((ItemLike)item, 1);
        int remainingCount = count;
        if (stackToAdd.isStackable()) {
            for (i = 0; i < inventory.items.size(); ++i) {
                ItemStack inventoryStack = (ItemStack)inventory.items.get(i);
                if (inventoryStack.getItem() != item || inventoryStack.getCount() >= inventoryStack.getMaxStackSize()) continue;
                int spaceLeft = inventoryStack.getMaxStackSize() - inventoryStack.getCount();
                int itemsToAdd = Math.min(spaceLeft, remainingCount);
                inventoryStack.grow(itemsToAdd);
                ((ServerPlayer)inventory.player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, i, inventory.getItem(i)));
                if ((remainingCount -= itemsToAdd) != 0) continue;
                return 0;
            }
        }
        for (i = 0; i < inventory.items.size(); ++i) {
            if (!inventory.getItem(i).isEmpty()) continue;
            if (stackToAdd.isStackable()) {
                int stackSize = Math.min(stackToAdd.getMaxStackSize(), remainingCount);
                inventory.setItem(i, new ItemStack((ItemLike)item, stackSize));
                ((ServerPlayer)inventory.player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, i, inventory.getItem(i)));
                remainingCount -= stackSize;
            } else {
                inventory.setItem(i, stackToAdd.copy());
                ((ServerPlayer)inventory.player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, i, inventory.getItem(i)));
                --remainingCount;
            }
            if (remainingCount != 0) continue;
            return 0;
        }
        return remainingCount;
    }
}

