/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import mod.pbj.PointBlankInitializer;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public final class InternalFiles {
    private InternalFiles() {
    }

    public static void copyModFile(String srcPath, Path root, String path) {
        URL url = PointBlankInitializer.class.getResource(srcPath);
        try {
            if (url != null) {
                FileUtils.copyURLToFile((URL)url, (File)root.resolve(path).toFile());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyModDirectory(Class<?> resourceClass, String srcPath, Path root, String path) {
        URL url = resourceClass.getResource(srcPath);
        try {
            if (url != null) {
                InternalFiles.copyFolder(url.toURI(), root.resolve(path));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyModDirectory(String srcPath, Path root, String path) {
        InternalFiles.copyModDirectory(PointBlankInitializer.class, srcPath, root, path);
    }

    @Nullable
    public static InputStream readModFile(String filePath) {
        URL url = PointBlankInitializer.class.getResource(filePath);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Path> searchFolder(URI sourceURI, int depth) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        if ("jar".equals(sourceURI.getScheme())) {
            FileSystem fs;
            try {
                fs = FileSystems.getFileSystem(sourceURI);
            }
            catch (ProviderNotFoundException ignored) {
                fs = FileSystems.newFileSystem(sourceURI, Collections.emptyMap());
            }
            try (FileSystem jarFs = fs;){
                String internalPath;
                Path sourcePath = jarFs.getPath("/", new String[0]);
                String jarPath = sourceURI.toString();
                int exclamationIndex = jarPath.lastIndexOf("!/");
                if (exclamationIndex != -1 && !(internalPath = jarPath.substring(exclamationIndex + 2)).isEmpty()) {
                    sourcePath = jarFs.getPath(internalPath, new String[0]);
                }
                if (!Files.exists(sourcePath, new LinkOption[0])) return paths;
                try (Stream<Path> stream = Files.walk(sourcePath, depth, new FileVisitOption[0]);){
                    Path finalSourcePath = sourcePath;
                    stream.forEach(source -> {
                        Path relativePath = finalSourcePath.relativize((Path)source);
                        paths.add(relativePath);
                        System.out.println(relativePath);
                    });
                    return paths;
                }
            }
        }
        Path sourcePath = Paths.get(sourceURI);
        try (Stream<Path> stream = Files.walk(sourcePath, depth, new FileVisitOption[0]);){
            stream.forEach(source -> {
                Path relativePath = sourcePath.relativize((Path)source);
                paths.add(relativePath);
                System.out.println(relativePath);
            });
            return paths;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFolder(URI sourceURI, Path targetPath) throws IOException {
        if (Files.isDirectory(targetPath, new LinkOption[0])) {
            InternalFiles.deleteFiles(targetPath);
        }
        if ("jar".equals(sourceURI.getScheme())) {
            FileSystem fs;
            try {
                fs = FileSystems.getFileSystem(sourceURI);
            }
            catch (ProviderNotFoundException ignored) {
                fs = FileSystems.newFileSystem(sourceURI, Collections.emptyMap());
            }
            try (FileSystem jarFs = fs;){
                String internalPath;
                Path sourcePath = jarFs.getPath("/", new String[0]);
                String jarPath = sourceURI.toString();
                int exclamationIndex = jarPath.lastIndexOf("!/");
                if (exclamationIndex != -1 && !(internalPath = jarPath.substring(exclamationIndex + 2)).isEmpty()) {
                    sourcePath = jarFs.getPath(internalPath, new String[0]);
                }
                if (!Files.exists(sourcePath, new LinkOption[0])) return;
                try (Stream<Path> stream = Files.walk(sourcePath, Integer.MAX_VALUE, new FileVisitOption[0]);){
                    Path finalSourcePath = sourcePath;
                    stream.forEach(source -> {
                        try {
                            Path relativePath = finalSourcePath.relativize((Path)source);
                            Path target = targetPath.resolve(relativePath.toString());
                            if (Files.isDirectory(source, new LinkOption[0])) {
                                Files.createDirectories(target, new FileAttribute[0]);
                            } else {
                                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                    return;
                }
            }
        }
        Path sourcePath = Paths.get(sourceURI);
        try (Stream<Path> stream = Files.walk(sourcePath, Integer.MAX_VALUE, new FileVisitOption[0]);){
            stream.forEach(source -> {
                try {
                    Path relativePath = sourcePath.relativize((Path)source);
                    Path target = targetPath.resolve(relativePath.toString());
                    if (Files.isDirectory(source, new LinkOption[0])) {
                        Files.createDirectories(target, new FileAttribute[0]);
                    } else {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            return;
        }
    }

    public static void deleteFiles(Path targetPath) throws IOException {
        Files.walkFileTree(targetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

