/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.registry;

import mod.pbj.PointBlankInitializer;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.function.MathFunction;
import software.bernie.geckolib.loading.math.value.Variable;

public final class MolangRegistry {
    public static final String AMMO = "pbj.ammo";
    public static final String FIREMODE = "pbj.firemode";
    public static final String FIRETICKS = "pbj.fireticks";
    public static final String TOTALSHOTS = "pbj.totalshots";
    public static final String AIMING = "pbj.aiming";
    public static final String AIMPROG = "pbj.aimprog";
    public static final String HEADBOB = "pbj.headbob";
    public static final String HEADROTX = "pbj.headrotx";
    public static final String HEADROTY = "pbj.headroty";
    public static final String CRAWLING = "pbj.crawl";
    public static final String CROUCHING = "pbj.crouch";

    public static void init() {
        PointBlankInitializer.LOGGER.info("Registering Molang variables and functions");
        MathParser.registerVariable((Variable)new Variable(AMMO, 0.0));
        MathParser.registerVariable((Variable)new Variable(FIREMODE, 0.0));
        MathParser.registerVariable((Variable)new Variable(FIRETICKS, 0.0));
        MathParser.registerVariable((Variable)new Variable(TOTALSHOTS, 0.0));
        MathParser.registerVariable((Variable)new Variable(AIMING, 0.0));
        MathParser.registerVariable((Variable)new Variable(AIMPROG, 0.0));
        MathParser.registerVariable((Variable)new Variable(HEADBOB, 0.0));
        MathParser.registerVariable((Variable)new Variable(HEADROTX, 0.0));
        MathParser.registerVariable((Variable)new Variable(HEADROTY, 0.0));
        MathParser.registerVariable((Variable)new Variable(CROUCHING, 0.0));
        MathParser.registerVariable((Variable)new Variable(CRAWLING, 0.0));
        MathParser.registerFunction((String)"pbj.e_inoutquart", InOutQuart::new);
    }

    public static final class InOutQuart
    extends MathFunction {
        private final MathValue value;

        public InOutQuart(MathValue ... values) {
            super(values);
            this.value = values[0];
        }

        public String getName() {
            return "pbj.e_inoutquart";
        }

        public double compute() {
            double x = this.getArgs()[0].get();
            return x < 0.5 ? 8.0 * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 4.0) / 2.0;
        }

        public int getMinArgs() {
            return 1;
        }

        public MathValue[] getArgs() {
            return new MathValue[]{this.value};
        }
    }
}

