/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.pbj.Enableable;
import mod.pbj.Platform;
import mod.pbj.RegistryService;
import mod.pbj.config.ConfigManager;
import mod.pbj.config.Configurable;
import mod.pbj.entity.EntityBuilderProvider;
import mod.pbj.item.AttachmentItem;
import mod.pbj.item.ItemBuilder;
import mod.pbj.registry.AmmoRegistry;
import mod.pbj.registry.BlockRegistry;
import mod.pbj.registry.EntityRegistry;
import mod.pbj.registry.MiscItemRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class ItemRegistry {
    public static RegistryService<Item> itemRegistry = Platform.getInstance().getItemRegistry();
    private static RegistryService<CreativeModeTab> tabRegistry = Platform.getInstance().getCreativeModeTabRegistry();
    private Map<String, Supplier<? extends Item>> itemsByName = new LinkedHashMap<String, Supplier<? extends Item>>();
    private Map<String, List<Supplier<? extends Item>>> itemsByGroup = new LinkedHashMap<String, List<Supplier<? extends Item>>>();
    public static final ItemRegistry ITEMS = new ItemRegistry();
    private final ConfigManager.Builder itemConfigBuilder = new ConfigManager.Builder("pointblank-items");
    public static final Supplier<CreativeModeTab> POINTBLANK_TAB = tabRegistry.register("pointblank", () -> CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).title((Component)Component.translatable((String)"itemGroup.pointblank.items")).icon(() -> new ItemStack((ItemLike)BlockRegistry.PRINTER.get())).displayItems((enabledFeatures, entries) -> {
        Consumer<ItemLike> output = itemLike -> {
            Enableable e;
            if (itemLike != null && (!(itemLike instanceof Enableable) || (e = (Enableable)itemLike).isEnabled())) {
                entries.accept(itemLike);
            }
        };
        AmmoRegistry.registerTabItems(output);
        MiscItemRegistry.registerTabItems(output);
    }).build());

    public Map<String, Supplier<? extends Item>> getItemsByName() {
        return Collections.unmodifiableMap(this.itemsByName);
    }

    public List<Supplier<? extends Item>> getAttachmentsForGroup(String group) {
        List<Supplier<? extends Item>> groupAttachments = this.itemsByGroup.get(group);
        return groupAttachments != null ? Collections.unmodifiableList(groupAttachments) : Collections.emptyList();
    }

    public <I extends Item, T extends ItemBuilder<T>> Supplier<I> register(ItemBuilder<?> itemBuilder) {
        EntityBuilderProvider entityBuilderProvider;
        String name = itemBuilder.getName();
        if (itemBuilder instanceof Configurable) {
            Configurable configurable = (Configurable)((Object)itemBuilder);
            configurable.configure(this.itemConfigBuilder);
        }
        Supplier<Item> ro = itemRegistry.register(name, new ItemSupplier(itemBuilder));
        this.itemsByName.put(name, ro);
        if (itemBuilder instanceof AttachmentItem.Builder) {
            AttachmentItem.Builder attachmentBuilder = (AttachmentItem.Builder)itemBuilder;
            for (String group : attachmentBuilder.getGroups()) {
                List groupMembers = this.itemsByGroup.computeIfAbsent(group, g -> new ArrayList());
                groupMembers.add(ro);
            }
        }
        if ((entityBuilderProvider = itemBuilder.getEntityBuilderProvider()) != null) {
            EntityRegistry.registerItemEntity(name, entityBuilderProvider::getEntityBuilder);
        }
        return ro;
    }

    public <I extends Item> Supplier<I> getDeferredRegisteredObject(String name) {
        String normalizedName = name;
        return () -> {
            Supplier<? extends Item> registryObject = this.itemsByName.get(normalizedName);
            return registryObject != null ? registryObject.get() : null;
        };
    }

    public static void complete() {
        ItemRegistry.ITEMS.itemConfigBuilder.build();
    }

    public static void init() {
        MiscItemRegistry.init();
        AmmoRegistry.init();
    }

    public void syncEnabledItems(List<Integer> enabledItemIds) {
        Item item;
        HashSet<Item> enabledItemSet = new HashSet<Item>();
        for (Integer n : enabledItemIds) {
            item = Item.byId((int)n);
            enabledItemSet.add(item);
        }
        for (Supplier supplier : this.itemsByName.values()) {
            item = (Item)supplier.get();
            if (enabledItemSet.contains(item) || !(item instanceof Enableable)) continue;
            Enableable e = (Enableable)item;
            e.setEnabled(false);
        }
    }

    public static class ItemSupplier
    implements Supplier<Item> {
        private final ItemBuilder<?> itemBuilder;

        ItemSupplier(ItemBuilder<?> itemBuilder) {
            this.itemBuilder = itemBuilder;
        }

        public boolean isEnabled() {
            Enableable e;
            ItemBuilder<?> itemBuilder = this.itemBuilder;
            return !(itemBuilder instanceof Enableable) || (e = (Enableable)((Object)itemBuilder)).isEnabled();
        }

        @Override
        public Item get() {
            if (this.isEnabled()) {
                return this.itemBuilder.build();
            }
            return null;
        }
    }
}

