/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.registry;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import mod.pbj.Platform;
import mod.pbj.RegistryService;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;

public class DataComponentRegistry {
    private static RegistryService<DataComponentType<?>> dataComponentTypeRegistry = Platform.getInstance().getDataComponentTypeRegistry();
    public static final Supplier<DataComponentType<Long>> TIMESTAMP_COMPONENT = DataComponentRegistry.registerDataComponent("ts", builder -> builder.persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG));
    public static final Supplier<DataComponentType<CompoundTag>> CUSTOM_TAG_COMPONENT = DataComponentRegistry.registerDataComponent("custom_tag", builder -> builder.persistent(CompoundTag.CODEC).networkSynchronized(ByteBufCodecs.COMPOUND_TAG));
    public static final Supplier<DataComponentType<CompoundTag>> SLOT_CONTENTS_COMPONENT = DataComponentRegistry.registerDataComponent("slot_contents", builder -> builder.persistent(CompoundTag.CODEC).networkSynchronized(ByteBufCodecs.COMPOUND_TAG));

    public static <T> Supplier<DataComponentType<T>> registerDataComponent(String id, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return dataComponentTypeRegistry.register(id, () -> ((DataComponentType.Builder)builder.apply(new DataComponentType.Builder())).build());
    }

    public static void init() {
    }
}

