/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import java.util.UUID;
import mod.pbj.NetworkService;
import mod.pbj.Platform;
import mod.pbj.client.GunClientState;
import mod.pbj.network.GunStateRequestPacket;
import mod.pbj.network.MainHeldSimplifiedStateBroadcastPacket;
import mod.pbj.util.MiscUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class MainHeldSimplifiedStateSyncRequest
extends GunStateRequestPacket {
    private static final int MAX_STATE_SYNC_DISTANCE_SQR = 10000;
    private GunClientState.FireState simplifiedState;

    public MainHeldSimplifiedStateSyncRequest() {
    }

    public MainHeldSimplifiedStateSyncRequest(UUID stateId, GunClientState.FireState simplifiedState) {
        super(stateId, 0);
        this.simplifiedState = simplifiedState;
    }

    @Override
    protected void doEncode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.simplifiedState.ordinal());
    }

    public static MainHeldSimplifiedStateSyncRequest decode(FriendlyByteBuf buffer) {
        GunStateRequestPacket header = GunStateRequestPacket.decodeHeader(buffer);
        GunClientState.FireState state = GunClientState.FireState.values()[buffer.readInt()];
        return new MainHeldSimplifiedStateSyncRequest(header.stateId, state);
    }

    @Override
    protected <T extends GunStateRequestPacket> void handleEnqueued(NetworkService.MessageContext ctx) {
        ServerPlayer sender = (ServerPlayer)ctx.getSender();
        for (ServerPlayer player : ((ServerLevel)MiscUtil.getLevel((Entity)sender)).getPlayers(p -> true)) {
            if (player == sender || !(player.distanceToSqr(player.position()) < 10000.0)) continue;
            Platform.getInstance().getNetworkService().sendToClient(new MainHeldSimplifiedStateBroadcastPacket((Player)sender, this.stateId, this.simplifiedState), (Player)player);
        }
    }
}

