/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.item.AmmoItem;
import mod.pbj.registry.DataComponentRegistry;
import mod.pbj.registry.SoundRegistry;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SlotFeature
extends ConditionalFeature {
    public int maxWeight = 64;
    public final Predicate<ItemStack> filter;

    public SlotFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, int maxWeight, Predicate<ItemStack> filter) {
        super(owner, predicate);
        this.maxWeight = maxWeight;
        this.filter = filter;
    }

    public static void removeItemAt(ItemStack stack, int i) {
        List<ItemStack> contents = SlotFeature.getSlotContents(stack);
        if (i < 0 || i >= contents.size()) {
            return;
        }
        contents.remove(i);
        CompoundTag tag = (CompoundTag)stack.getOrDefault(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)SlotFeature.defaultTag());
        tag = tag.copy();
        ListTag items = new ListTag();
        for (ItemStack itemStack : contents) {
            items.add((Object)((Tag)ItemStack.CODEC.encode((Object)itemStack, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow()));
        }
        tag.put("Items", (Tag)items);
        stack.set(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)tag);
    }

    public static void shrinkItemAt(ItemStack stack, int i, int by) {
        List<ItemStack> contents = SlotFeature.getSlotContents(stack);
        if (i < 0 || i >= contents.size()) {
            return;
        }
        contents.get(i).shrink(by);
        CompoundTag tag = (CompoundTag)stack.getOrDefault(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)SlotFeature.defaultTag());
        tag = tag.copy();
        ListTag items = new ListTag();
        for (ItemStack itemStack : contents) {
            items.add((Object)((Tag)ItemStack.CODEC.encode((Object)itemStack, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow()));
        }
        tag.put("Items", (Tag)items);
        stack.set(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)tag);
    }

    @Override
    public Component getDescription() {
        return Component.literal((String)("Max Weight: " + this.maxWeight));
    }

    public static boolean itemStackedOn(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (other.isEmpty() && action == ClickAction.SECONDARY) {
            if (!SlotFeature.getSlotContents(stack).isEmpty()) {
                player.playSound(SoundRegistry.ATTACHMENT_REMOVED.get());
            }
            access.set(SlotFeature.removeSlotItem(stack));
            return true;
        }
        if (!other.isEmpty() && action == ClickAction.SECONDARY) {
            int maxWeight = 0;
            Predicate<ItemStack> combinedFilter = s -> false;
            for (SlotFeature feature2 : Features.getEnabledFeatures(stack, SlotFeature.class).stream().map(Features.EnabledFeature::feature).map(feature -> (SlotFeature)feature).toList()) {
                maxWeight += feature2.maxWeight;
                combinedFilter = combinedFilter.or(feature2.filter);
            }
            if (!combinedFilter.test(other)) {
                player.playSound(SoundRegistry.ERROR.get());
                return false;
            }
            if (SlotFeature.getComputedWeight(stack) + SlotFeature.getItemWeight(other.copyWithCount(1)) >= maxWeight) {
                player.playSound(SoundRegistry.ERROR.get());
            }
            if (maxWeight <= 0) {
                player.playSound(SoundRegistry.ERROR.get());
                return false;
            }
            CompoundTag tag = SlotFeature.addSlotContents(stack, other, maxWeight, player);
            stack.set(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)tag);
            return true;
        }
        return false;
    }

    public static int getItemWeight(ItemStack stack) {
        return (int)((double)stack.getCount() / (double)stack.getMaxStackSize() * 64.0);
    }

    private static ItemStack removeSlotItem(ItemStack stack) {
        List<ItemStack> contents = SlotFeature.getSlotContents(stack);
        if (contents.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack toReturn = contents.removeLast();
        CompoundTag tag = (CompoundTag)stack.getOrDefault(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)SlotFeature.defaultTag());
        tag = tag.copy();
        ListTag items = new ListTag();
        for (ItemStack itemStack : contents) {
            items.add((Object)((Tag)ItemStack.CODEC.encode((Object)itemStack, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow()));
        }
        tag.put("Items", (Tag)items);
        stack.set(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)tag);
        return toReturn;
    }

    public static List<ItemStack> getSlotContents(ItemStack stack) {
        CompoundTag tag = (CompoundTag)stack.getOrDefault(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)SlotFeature.defaultTag());
        ListTag items = tag.getList("Items", 10);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Tag itemTag : items) {
            CompoundTag itemCompound;
            ItemStack itemStack;
            if (!(itemTag instanceof CompoundTag) || (itemStack = (ItemStack)ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)(itemCompound = (CompoundTag)itemTag)).getOrThrow()).isEmpty()) continue;
            result.add(itemStack);
        }
        return result;
    }

    private static CompoundTag addSlotContents(ItemStack stack, ItemStack toAdd, int maxWeight, Player player) {
        int itemCount;
        CompoundTag tag = (CompoundTag)stack.getOrDefault(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)SlotFeature.defaultTag());
        tag = tag.copy();
        ListTag items = tag.getList("Items", 10);
        int currentWeight = SlotFeature.getComputedWeight(stack);
        int itemWeight = 0;
        for (itemCount = 0; currentWeight + itemWeight < maxWeight && itemCount < toAdd.getCount(); ++itemCount) {
            itemWeight += SlotFeature.getItemWeight(toAdd.copyWithCount(1));
        }
        ItemStack finalItem = toAdd.copyWithCount(itemCount);
        if (!finalItem.isEmpty()) {
            items.add((Object)((Tag)ItemStack.CODEC.encode((Object)finalItem, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow()));
            player.playSound(SoundRegistry.ATTACHMENT_ADDED.get());
        }
        toAdd.shrink(itemCount);
        tag.put("Items", (Tag)items);
        return tag;
    }

    public static int getComputedWeight(ItemStack stack) {
        return SlotFeature.getSlotContents(stack).stream().mapToInt(SlotFeature::getItemWeight).sum();
    }

    public static CompoundTag defaultTag() {
        CompoundTag tag = new CompoundTag();
        tag.put("Items", (Tag)new ListTag());
        return tag;
    }

    public static class Builder
    implements FeatureBuilder<Builder, SlotFeature> {
        private int maxWeight;
        private Predicate<ConditionContext> predicate = ctx -> true;
        private Predicate<ItemStack> filter = stack -> true;

        @Override
        public Builder withJsonObject(JsonObject obj) {
            this.maxWeight = JsonUtil.getJsonInt(obj, "maxWeight", 64);
            if (obj.has("condition")) {
                this.predicate = Conditions.fromJson((JsonElement)obj.get("condition").getAsJsonObject());
            }
            if (obj.has("filter")) {
                List<String> filters = obj.getAsJsonArray("filter").asList().stream().map(JsonElement::getAsString).toList();
                this.filter = stack -> false;
                for (String s : filters) {
                    if (s.startsWith("#")) {
                        String tag = s.substring(1);
                        this.filter = this.filter.or(stack -> stack.is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tag))));
                        continue;
                    }
                    if (s.equalsIgnoreCase("AmmoItem")) {
                        this.filter = this.filter.or(stack -> stack.getItem() instanceof AmmoItem);
                        continue;
                    }
                    this.filter = this.filter.or(stack -> stack.getItem().builtInRegistryHolder().getRegisteredName().equals(s));
                }
            }
            return this;
        }

        @Override
        public SlotFeature build(FeatureProvider featureProvider) {
            return new SlotFeature(featureProvider, this.predicate, this.maxWeight, this.filter);
        }
    }
}

