/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeFeature
extends ConditionalFeature {
    public final Holder.Reference<Attribute> baseAttribute;
    public final AttributeModifier modifier;

    public AttributeFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, Holder.Reference<Attribute> baseAttribute, AttributeModifier modifier) {
        super(owner, predicate);
        this.baseAttribute = baseAttribute;
        this.modifier = modifier;
    }

    @Override
    public Component getDescription() {
        return MutableComponent.create((ComponentContents)Component.translatable((String)((Attribute)this.baseAttribute.value()).getDescriptionId()).getContents()).append(": %s".formatted(this.getFormattedModifier(this.modifier)));
    }

    private String getFormattedModifier(AttributeModifier modifier) {
        Object string = switch (modifier.operation()) {
            default -> throw new MatchException(null, null);
            case AttributeModifier.Operation.ADD_VALUE -> "+ ";
            case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> "base x ";
            case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> "x ";
        };
        string = (String)string + modifier.amount();
        return string;
    }

    public static class Builder
    implements FeatureBuilder<Builder, AttributeFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private Holder.Reference<Attribute> baseAttribute;
        private AttributeModifier modifier;
        public static final HashMap<AttributeModifier.Operation, String[]> modifierValues = new HashMap();

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withAttribute(Holder.Reference<Attribute> attribute) {
            this.baseAttribute = attribute;
            return this;
        }

        public Builder withAttributeModifier(AttributeModifier attributeModifier) {
            this.modifier = attributeModifier;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            ResourceLocation attribute = ResourceLocation.parse((String)JsonUtil.getJsonString(obj, "attribute"));
            this.withAttribute((Holder.Reference<Attribute>)((Holder.Reference)BuiltInRegistries.ATTRIBUTE.getHolder(attribute).orElseThrow()));
            JsonObject modObj = obj.getAsJsonObject("modifier");
            if (modObj == null) {
                throw new IllegalStateException("AttributeFeature needs a \"modifier\" object!");
            }
            AttributeModifier modifier = new AttributeModifier(attribute, modObj.get("amount").getAsDouble(), Builder.operationFromString(modObj.has("operator") ? modObj.get("operator").getAsString() : modObj.get("operation").getAsString()));
            this.withAttributeModifier(modifier);
            return this;
        }

        public static AttributeModifier.Operation operationFromString(String str) {
            AttributeModifier.Operation[] fop = new AttributeModifier.Operation[]{null};
            modifierValues.forEach((op, strArr) -> {
                for (String key : strArr) {
                    if (!str.trim().equalsIgnoreCase(key)) continue;
                    fop[0] = op;
                    return;
                }
            });
            return fop[0];
        }

        @Override
        public AttributeFeature build(FeatureProvider featureProvider) {
            return new AttributeFeature(featureProvider, this.condition, this.baseAttribute, this.modifier);
        }

        static {
            modifierValues.put(AttributeModifier.Operation.ADD_VALUE, new String[]{"add_value", "addition", "+"});
            modifierValues.put(AttributeModifier.Operation.ADD_MULTIPLIED_BASE, new String[]{"add_multiplied_base", "multiply_base", "*b", "xb"});
            modifierValues.put(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, new String[]{"add_multiplied_total", "multiply_total", "*", "x"});
        }
    }
}

