/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.compat.iris;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.FileNotFoundException;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.pbj.client.ClientSystem;
import mod.pbj.client.render.Flushable;
import mod.pbj.client.render.RenderTypeProvider;
import mod.pbj.compat.iris.IrisAuxShaderProvider;
import net.irisshaders.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class IrisRenderTypeProvider
extends RenderStateShard
implements RenderTypeProvider {
    private Function<Boolean, RenderType> pipRenderTypes = Util.memoize(isMasked -> this.createPipRenderType((boolean)isMasked));
    private final Function<ResourceLocation, RenderType> pipMaskRenderTypes = Util.memoize(texture -> this.createPipMaskRenderType(IrisRenderTypeProvider.getIrisTexture(texture), this::getPipMaskShader));
    private final Function<ResourceLocation, RenderType> pipOverlayRenderTypes = Util.memoize(texture -> IrisRenderTypeProvider.createPipOverlayRenderType(IrisRenderTypeProvider.getIrisTexture(texture), GameRenderer::getPositionTexColorShader, false));
    private final Function<ResourceLocation, RenderType> pipOverlayMaskedRenderTypes = Util.memoize(texture -> IrisRenderTypeProvider.createPipOverlayRenderType(IrisRenderTypeProvider.getIrisTexture(texture), this::getPipOverlayShader, true));
    private final Function<ResourceLocation, RenderType> reticleRenderTypes = Util.memoize(texture -> IrisRenderTypeProvider.createReticleRenderType(IrisRenderTypeProvider.getIrisTexture(texture)));
    private final Function<ResourceLocation, RenderType> reticleRenderTypesWithParallax = Util.memoize(texture -> IrisRenderTypeProvider.createReticleRenderType(IrisRenderTypeProvider.getIrisTexture(texture), GameRenderer::getPositionTexColorShader));
    private final Function<ResourceLocation, RenderType> glowRenderTypes = Util.memoize(texture -> GlowRenderType.createRenderType(IrisRenderTypeProvider.getIrisTexture(texture)));

    public IrisRenderTypeProvider() {
        super(null, null, null);
    }

    @Override
    public MultiBufferSource wrapBufferSource(MultiBufferSource source) {
        return new WrappedBufferSource(source);
    }

    @Override
    public RenderType getPipRenderType(boolean isMasked) {
        return this.pipRenderTypes.apply(isMasked);
    }

    private ShaderInstance getPipShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        ShaderInstance shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankAuxShader();
        }
        if (shader == null) {
            shader = GameRenderer.getPositionTexColorShader();
        }
        return shader;
    }

    private ShaderInstance getPipOverlayShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        ShaderInstance shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankAuxPlainShader();
        }
        if (shader == null) {
            shader = GameRenderer.getPositionTexColorShader();
        }
        return shader;
    }

    private ShaderInstance getPipMaskShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        ShaderInstance shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankMaskShader();
        }
        if (shader == null) {
            shader = GameRenderer.getPositionTexColorShader();
        }
        return shader;
    }

    @Override
    public RenderType getPipOverlayRenderType(ResourceLocation texture, boolean isMasked) {
        return isMasked ? this.pipOverlayMaskedRenderTypes.apply(texture) : this.pipOverlayRenderTypes.apply(texture);
    }

    @Override
    public RenderType getPipMaskRenderType(ResourceLocation texture) {
        return this.pipMaskRenderTypes.apply(texture);
    }

    @Override
    public RenderType getGlowRenderType(ResourceLocation texture) {
        return this.glowRenderTypes.apply(texture);
    }

    @Override
    public RenderType getGlowBlockEntityRenderType(ResourceLocation texture) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }

    @Override
    public RenderType getMuzzleFlashRenderType(ResourceLocation texture) {
        return RenderType.entityTranslucentEmissive((ResourceLocation)texture);
    }

    @Override
    public RenderType getReticleRenderType(ResourceLocation texture, boolean isParallaxEnabled) {
        return isParallaxEnabled ? this.reticleRenderTypesWithParallax.apply(texture) : this.reticleRenderTypes.apply(texture);
    }

    private static ResourceLocation getIrisTexture(ResourceLocation originalTexture) {
        Minecraft mc = Minecraft.getInstance();
        ResourceManager resourceManager = mc.getResourceManager();
        String path = originalTexture.getPath();
        if (path.endsWith(".png")) {
            String modifiedPath = path.replace(".png", "_iris.png");
            ResourceLocation irisTexture = ResourceLocation.fromNamespaceAndPath((String)originalTexture.getNamespace(), (String)modifiedPath);
            try {
                resourceManager.getResourceOrThrow(irisTexture);
                return irisTexture;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return originalTexture;
    }

    private static RenderType createReticleRenderType(ResourceLocation texture, Supplier<ShaderInstance> shaderSupplier) {
        return RenderType.create((String)"pointblank:reticle_iris_with_parallax", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setDepthTestState(LEQUAL_DEPTH_TEST).setLightmapState(NO_LIGHTMAP).setOverlayState(NO_OVERLAY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setShaderState(new RenderStateShard.ShaderStateShard(shaderSupplier::get)).createCompositeState(false));
    }

    private static RenderType createReticleRenderType(ResourceLocation texture) {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).createCompositeState(true);
        return RenderType.create((String)"pointblank:reticle_iris", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState);
    }

    private RenderType createPipRenderType(boolean isMasked) {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(this::getPipShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new PipTextureStateShard()).setTransparencyState(NO_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setOverlayState(NO_OVERLAY).createCompositeState(true);
        Runnable setup = isMasked ? SETUP_STENCIL_RENDER : () -> {};
        Runnable clear = isMasked ? CLEAR_STENCIL_RENDER : () -> {};
        return RenderTypeProvider.wrapRenderType((RenderType)RenderType.create((String)("pointblank:pip_iris_" + isMasked), (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState), setup, clear);
    }

    private RenderType createPipMaskRenderType(ResourceLocation maskTexture, Supplier<ShaderInstance> shaderSupplier) {
        return RenderTypeProvider.wrapRenderType((RenderType)RenderType.create((String)"pointblank:pip_mask_iris", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setDepthTestState(NO_DEPTH_TEST).setLightmapState(NO_LIGHTMAP).setOverlayState(NO_OVERLAY).setTransparencyState(NO_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(maskTexture, false, false)).setShaderState(new RenderStateShard.ShaderStateShard(shaderSupplier::get)).createCompositeState(false)), RenderTypeProvider.SETUP_STENCIL_MASK_RENDER, RenderTypeProvider.CLEAR_STENCIL_MASK_RENDER);
    }

    private static RenderType createPipOverlayRenderType(ResourceLocation overlayTexture, Supplier<ShaderInstance> shaderSupplier, boolean isMasked) {
        Runnable setup = isMasked ? SETUP_STENCIL_RENDER : () -> {};
        Runnable clear = isMasked ? CLEAR_STENCIL_RENDER : () -> {};
        return RenderTypeProvider.wrapRenderType((RenderType)RenderType.create((String)("pointblank:pip_overlay_iris_" + isMasked), (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setDepthTestState(LEQUAL_DEPTH_TEST).setLightmapState(NO_LIGHTMAP).setOverlayState(NO_OVERLAY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(overlayTexture, false, false)).setShaderState(new RenderStateShard.ShaderStateShard(shaderSupplier::get)).createCompositeState(false)), setup, clear);
    }

    @Override
    public float getReticleBrightness() {
        return 0.6f;
    }

    @Override
    public float getGlowBrightness() {
        return 0.6f;
    }

    private static class WrappedBufferSource
    implements MultiBufferSource,
    Flushable {
        private final MultiBufferSource delegate;

        WrappedBufferSource(MultiBufferSource delegate) {
            this.delegate = delegate;
        }

        @Override
        public void flush() {
            MultiBufferSource multiBufferSource = this.delegate;
            if (multiBufferSource instanceof FullyBufferedMultiBufferSource) {
                FullyBufferedMultiBufferSource fbmbs = (FullyBufferedMultiBufferSource)multiBufferSource;
                fbmbs.endBatch();
            }
        }

        public VertexConsumer getBuffer(RenderType renderType) {
            if (renderType == RenderTypeProvider.NO_RENDER_TYPE) {
                return null;
            }
            return this.delegate.getBuffer(renderType);
        }
    }

    private static class PipTextureStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        public PipTextureStateShard() {
            super(() -> {
                int textureId = ClientSystem.getInstance().getAuxLevelRenderer().getRenderTarget().getColorTextureId();
                RenderSystem.setShaderTexture((int)0, (int)textureId);
            }, () -> {});
        }
    }

    private static final class GlowRenderType
    extends RenderType {
        public GlowRenderType(String renderTypeName, VertexFormat vertexFormat, VertexFormat.Mode mode, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
            super(renderTypeName, vertexFormat, mode, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
        }

        private static RenderType createRenderType(ResourceLocation glowTexture) {
            return RenderType.create((String)"pointblank:glow_iris", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setDepthTestState(LEQUAL_DEPTH_TEST).setLightmapState(LIGHTMAP).setOverlayState(NO_OVERLAY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(glowTexture, false, false)).setShaderState(RenderStateShard.RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER).createCompositeState(false));
        }
    }
}

