/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.pbj.client.render.ArmorInHandRenderer;
import mod.pbj.client.render.HierarchicalRenderContext;
import mod.pbj.client.render.RenderPass;
import mod.pbj.client.render.RenderPassGeoRenderer;
import mod.pbj.feature.SkinFeature;
import mod.pbj.item.ArmorItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.Color;

public class ArmorItemRenderer
extends GeoArmorRenderer<ArmorItem>
implements RenderPassGeoRenderer<ArmorItem> {
    public ArmorInHandRenderer internal;

    public ArmorItemRenderer(ResourceLocation assetSubpath, ArmorInHandRenderer internal) {
        super((GeoModel)new DefaultedItemGeoModel(assetSubpath));
        this.internal = internal;
    }

    public void defaultRender(PoseStack poseStack, ArmorItem animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        try (HierarchicalRenderContext hrc = HierarchicalRenderContext.push(this.getCurrentStack(), ItemDisplayContext.FIXED);){
            poseStack.pushPose();
            Color renderColor = this.getRenderColor((Item)animatable, partialTick, packedLight);
            float red = renderColor.getRedFloat();
            float green = renderColor.getGreenFloat();
            float blue = renderColor.getBlueFloat();
            float alpha = renderColor.getAlphaFloat();
            int packedOverlay = this.getPackedOverlay((GeoAnimatable)animatable, 0.0f, partialTick);
            BakedGeoModel model = this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)animatable));
            if (renderType == null) {
                renderType = this.getRenderType((Item)animatable, this.getTextureLocation(animatable), bufferSource, partialTick);
            }
            if (buffer == null) {
                buffer = bufferSource.getBuffer(renderType);
            }
            this.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor.argbInt());
            if (this.firePreRenderEvent(poseStack, model, bufferSource, partialTick, packedLight)) {
                poseStack.pushPose();
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                poseStack.translate(-0.5, -2.0, -0.5);
                this.internal.renderByItem(this.currentStack, ItemDisplayContext.HEAD, poseStack, bufferSource, packedLight, packedOverlay);
                poseStack.popPose();
                this.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor.argbInt());
                this.firePostRenderEvent(poseStack, model, bufferSource, partialTick, packedLight);
            }
            poseStack.popPose();
            this.renderFinal(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor.argbInt());
        }
    }

    public ResourceLocation getTextureLocation(ArmorItem animatable) {
        ResourceLocation texture = null;
        HierarchicalRenderContext hrc = HierarchicalRenderContext.getRoot();
        if (hrc != null) {
            ItemStack itemStack = hrc.getItemStack();
            texture = SkinFeature.getTexture(itemStack, (Player)Minecraft.getInstance().player);
        }
        if (texture == null) {
            texture = super.getTextureLocation((GeoAnimatable)animatable);
        }
        return texture;
    }

    @Override
    public GeoRenderer<ArmorItem> getRenderer() {
        return this;
    }

    @Override
    public boolean isEffectLayer() {
        return false;
    }

    @Override
    public RenderType getRenderType() {
        return null;
    }

    @Override
    public boolean isSupportedItemDisplayContext(ItemDisplayContext var1) {
        return false;
    }

    @Override
    public RenderPass getRenderPass() {
        return RenderPass.MAIN_ITEM;
    }
}

