/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.model;

import java.util.ArrayList;
import java.util.List;
import mod.pbj.client.BiDirectionalInterpolator;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.GunClientState;
import mod.pbj.client.controller.BlendingAnimationProcessor;
import mod.pbj.item.FireModeInstance;
import mod.pbj.item.GunItem;
import mod.pbj.util.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.model.DefaultedItemGeoModel;

public class GunGeoModel
extends DefaultedItemGeoModel<GunItem> {
    private BakedGeoModel currentModel = null;
    private final List<ResourceLocation> fallbackAnimations;
    private final BlendingAnimationProcessor<GunItem> blendingAnimationProcessor = new BlendingAnimationProcessor(this);

    public GunGeoModel(ResourceLocation assetSubPath, List<ResourceLocation> fallbackAnimations) {
        super(assetSubPath);
        this.fallbackAnimations = new ArrayList<ResourceLocation>();
        for (ResourceLocation fallbackAnimation : fallbackAnimations) {
            this.fallbackAnimations.add(this.buildFormattedAnimationPath(fallbackAnimation));
        }
    }

    public AnimationProcessor<GunItem> getAnimationProcessor() {
        return this.blendingAnimationProcessor;
    }

    public BakedGeoModel getBakedModel(ResourceLocation location) {
        BakedGeoModel model = (BakedGeoModel)GeckoLibCache.getBakedModels().get(location);
        if (model == null) {
            if (!location.getPath().contains("geo/")) {
                throw GeckoLibConstants.exception((ResourceLocation)location, (String)"Invalid model resource path provided - GeckoLib models must be placed in assets/<modid>/geo/");
            }
            throw GeckoLibConstants.exception((ResourceLocation)location, (String)"Unable to find model");
        }
        if (model != this.currentModel) {
            this.blendingAnimationProcessor.setActiveModel(model);
            this.currentModel = model;
        }
        return this.currentModel;
    }

    public Animation getAnimation(GunItem animatable, String name) {
        ResourceLocation location = this.getAnimationResource((GeoAnimatable)animatable);
        BakedAnimations bakedAnimations = (BakedAnimations)GeckoLibCache.getBakedAnimations().get(location);
        Animation bakedAnimation = null;
        if (bakedAnimations != null) {
            bakedAnimation = bakedAnimations.getAnimation(name);
        }
        if (bakedAnimation == null) {
            for (ResourceLocation animationLocation : this.fallbackAnimations) {
                BakedAnimations altAnimations = (BakedAnimations)GeckoLibCache.getBakedAnimations().get(animationLocation);
                if (altAnimations == null || (bakedAnimation = altAnimations.getAnimation(name)) == null) continue;
                break;
            }
        }
        return bakedAnimation;
    }

    public void applyMolangQueries(AnimationState<GunItem> animationState, double animTime) {
        super.applyMolangQueries(animationState, animTime);
        if (Minecraft.getInstance().player == null) {
            return;
        }
        GunClientState state = GunClientState.getMainHeldState();
        if (state == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        MathParser.setVariable((String)"pbj.ammo", () -> GunItem.getClientSideAmmo(ClientUtil.getClientPlayer(), ClientUtil.getClientPlayer().getMainHandItem(), ClientUtil.getClientPlayer().getInventory().selected).orElse(0).intValue());
        MathParser.setVariable((String)"pbj.firemode", GunGeoModel::getFireModeIndex);
        MathParser.setVariable((String)"pbj.fireticks", state::getTotalUninterruptedFireTime);
        MathParser.setVariable((String)"pbj.totalshots", state::getTotalUninterruptedShots);
        MathParser.setVariable((String)"pbj.aiming", () -> state.isAiming() ? 0.0 : 1.0);
        BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)state.getAnimationController("aiming");
        double aimprog = aimingController == null ? 0.0 : aimingController.getValue();
        MathParser.setVariable((String)"pbj.aimprog", () -> aimprog);
        MathParser.setVariable((String)"pbj.headbob", () -> player.bob);
        MathParser.setVariable((String)"pbj.headrotx", () -> ((LocalPlayer)player).getXRot());
        MathParser.setVariable((String)"pbj.headroty", () -> ((LocalPlayer)player).getYRot());
        MathParser.setVariable((String)"pbj.crawl", () -> player.isVisuallyCrawling() ? 0.0 : 1.0);
        MathParser.setVariable((String)"pbj.crouch", () -> ClientEventHandler.crouchProg.update(player.isCrouching() && !state.isAiming() ? 1.0f : 0.0f));
        MathParser.setVariable((String)"query.health", () -> ((LocalPlayer)player).getHealth());
        MathParser.setVariable((String)"query.max_health", () -> ((LocalPlayer)player).getMaxHealth());
        MathParser.setVariable((String)"query.is_on_fire", () -> player.isOnFire() ? 1.0 : 0.0);
        MathParser.setVariable((String)"query.ground_speed", () -> {
            Vec3 velocity = player.getDeltaMovement();
            return Mth.sqrt((float)((float)(velocity.x * velocity.x + velocity.z * velocity.z)));
        });
        MathParser.setVariable((String)"query.yaw_speed", () -> player.getViewYRot((float)animTime - player.getViewYRot((float)animTime - 0.1f)));
    }

    public static int getFireModeIndex() {
        ItemStack stack;
        Player player = ClientUtil.getClientPlayer();
        ItemStack itemStack = stack = player != null ? player.getMainHandItem() : null;
        if (player != null && player.getMainHandItem().getItem() instanceof GunItem) {
            int i = 0;
            for (FireModeInstance fireMode : GunItem.getFireModes(stack)) {
                if (GunItem.getFireModeInstance(stack) == fireMode) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }
}

