/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.controller;

import java.util.Random;
import mod.pbj.client.GunClientState;
import mod.pbj.client.GunStateListener;
import mod.pbj.client.controller.AbstractProceduralAnimationController;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GunRandomizingAnimationController
extends AbstractProceduralAnimationController
implements GunStateListener {
    private double amplitude;
    private double currentAmplitude;
    private double theta;
    private long idleNanoTicksPerTransition;
    private long fireNanoTicksPerTransition;
    private boolean isIdle;
    private boolean isForward;
    private static double middleProgress = 1.0 - Math.sqrt(2.0) / 2.0;
    private final Random random;

    public GunRandomizingAnimationController(double amplitude, long idleDuration, long fireDuration) {
        super(idleDuration);
        this.amplitude = amplitude;
        this.random = new Random();
        this.idleNanoTicksPerTransition = idleDuration * 1000000L;
        this.fireNanoTicksPerTransition = fireDuration * 1000000L;
        this.reset(true, true, idleDuration, amplitude);
    }

    @Override
    public void onRenderTick(LivingEntity player, GunClientState gunClientState, ItemStack itemStack, ItemDisplayContext itemDisplayContext, float partialTicks) {
        super.onRenderTick(player, gunClientState, itemStack, itemDisplayContext, partialTicks);
        if (this.isDone) {
            double a = gunClientState.isAiming() ? this.currentAmplitude : this.amplitude;
            this.reset(true, true, this.idleNanoTicksPerTransition, a);
            return;
        }
        if (!this.isIdle && this.isForward && this.progress > middleProgress) {
            this.reset(false, false, this.nanoDuration, this.currentAmplitude);
        }
        double adjustedProgress = this.isIdle ? this.progress : (this.isForward ? 1.0 - (middleProgress - this.progress) / middleProgress : 1.0 - (1.0 - this.progress) / (1.0 - middleProgress));
        adjustedProgress = 0.5 - 0.5 * Math.cos(Math.PI * this.progress);
        this.roll = this.startRoll + (this.endRoll - this.startRoll) * adjustedProgress;
        this.pitch = this.startPitch + (this.endPitch - this.startPitch) * adjustedProgress;
        this.yaw = this.startYaw + (this.endYaw - this.startYaw) * adjustedProgress;
        this.posX = this.startPosX + (this.endPosX - this.startPosX) * adjustedProgress;
        this.posY = this.startPosY + (this.endPosY - this.startPosY) * adjustedProgress;
        this.posZ = this.startPosZ + (this.endPosZ - this.startPosZ) * adjustedProgress;
    }

    private void reset(boolean isIdle, boolean isForward, long nanoSecPerTransition, double radius) {
        this.isIdle = isIdle;
        this.isForward = isForward;
        this.nanoDuration = nanoSecPerTransition;
        double newTheta = this.theta + 1.5707963267948966 + this.random.nextDouble() * Math.PI;
        this.startPosX = this.posX;
        this.startPosY = this.posY;
        this.startPosZ = this.posZ;
        this.startRoll = this.roll;
        this.startPitch = this.pitch;
        this.startYaw = this.yaw;
        this.endRoll = -Math.signum(this.roll != 0.0 ? this.roll : 1.0) * this.random.nextDouble() * this.currentAmplitude * 1.0;
        this.endPitch = -Math.signum(this.pitch != 0.0 ? this.pitch : 1.0) * this.random.nextDouble() * this.currentAmplitude * 0.5;
        this.endYaw = -Math.signum(this.yaw != 0.0 ? this.yaw : 1.0) * this.random.nextDouble() * this.currentAmplitude * 0.5;
        this.endPosX = this.currentAmplitude * Math.cos(newTheta) * 1.0;
        this.endPosY = this.currentAmplitude * Math.sin(newTheta) * 1.0;
        this.endPosZ = this.random.nextDouble() * this.currentAmplitude * 1.0;
        this.theta = newTheta;
        this.currentAmplitude = isIdle ? radius * 0.5 : radius;
        if (isForward) {
            super.reset();
        }
    }

    @Override
    public void onStartFiring(LivingEntity player, GunClientState state, ItemStack itemStack) {
        double randomness = (double)state.getTotalUninterruptedShots() * 0.001;
        if (randomness > 0.01) {
            randomness = 0.01;
        }
        double a = state.isAiming() ? 0.5 : 1.0;
        this.reset(false, true, this.fireNanoTicksPerTransition, a * this.amplitude + randomness);
    }

    @Override
    public void onUpdateState(LivingEntity player, GunClientState state) {
        if (state.isAiming()) {
            this.currentAmplitude *= 0.99;
        }
    }
}

