/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.stream.Stream;
import mod.pbj.PointBlankInitializer;
import mod.pbj.util.InternalFiles;

public final class JarManager {
    public static String writeConfig(Path configPath) {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Path f = Files.createFile(configPath, new FileAttribute[0]);
            Files.writeString(f, (CharSequence)"true", new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "true";
    }

    public static void init() {
        File rootDirectory = new File("");
        Path configPath = rootDirectory.toPath().resolve("pointblank").resolve("overwrite.config");
        boolean allowBasePackOverwrite = false;
        try {
            allowBasePackOverwrite = Boolean.parseBoolean(Files.exists(configPath, new LinkOption[0]) ? Files.readString(configPath).trim() : JarManager.writeConfig(configPath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (allowBasePackOverwrite) {
            try {
                InternalFiles.copyFolder(PointBlankInitializer.class.getResource("/base_pack").toURI(), rootDirectory.toPath().resolve("pointblank").resolve("base_pack"));
                PointBlankInitializer.LOGGER.info("Writing base_pack...");
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            JarManager.searchForJars(rootDirectory.toPath().resolve("mods"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static FileSystem getJarFileSystem(URI uri) {
        try {
            return FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        catch (IOException | FileSystemAlreadyExistsException e) {
            if (e instanceof FileSystemAlreadyExistsException) {
                return FileSystems.getFileSystem(uri);
            }
            return FileSystems.getFileSystem(uri);
        }
    }

    private static void searchForJars(Path path) throws IOException {
        File rootDirectory = new File("");
        try (Stream<Path> stream = Files.list(path);){
            stream.forEach(p -> {
                if (p.toString().endsWith(".jar")) {
                    PointBlankInitializer.LOGGER.info("Found jar: {}", (Object)p.getFileName());
                    boolean isContentPack = false;
                    try {
                        URI jarUri = URI.create("jar:" + String.valueOf(p.toUri()));
                        FileSystem fs = JarManager.getJarFileSystem(jarUri);
                        Path dir = fs.getPath("/", new String[0]);
                        for (Path entry : Files.newDirectoryStream(dir)) {
                            if (!entry.getFileName().endsWith("ext.json")) continue;
                            isContentPack = true;
                            String folderName = p.getFileName().toString().replace(".jar", "");
                            PointBlankInitializer.LOGGER.info("Found ext.json in jar: {}, loading as content pack", (Object)p.getFileName());
                            Path contentDir = rootDirectory.toPath().resolve("pointblank").resolve(folderName);
                            if (Files.notExists(contentDir, new LinkOption[0])) {
                                Files.createDirectories(contentDir, new FileAttribute[0]);
                                InternalFiles.copyFolder(jarUri, contentDir);
                                continue;
                            }
                            PointBlankInitializer.LOGGER.info("Content pack already exists, skipping: {}", (Object)folderName);
                        }
                    }
                    catch (IOException e) {
                        PointBlankInitializer.LOGGER.error("Error reading jar file: {}", (Object)p.getFileName(), (Object)e);
                    }
                }
            });
        }
    }
}

