/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.pbj.Config;
import mod.pbj.Platform;
import mod.pbj.client.GunClientState;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.client.effect.EffectLauncher;
import mod.pbj.event.AttachmentRemovedEvent;
import mod.pbj.event.LivingDeathEvent;
import mod.pbj.event.LivingDropsEvent;
import mod.pbj.event.LivingEquipmentChangeEvent;
import mod.pbj.event.LivingSwapItemsEvent;
import mod.pbj.event.PlayerEvent;
import mod.pbj.event.ServerAboutToStartEvent;
import mod.pbj.event.ServerStartedEvent;
import mod.pbj.event.SubscribeEvent2;
import mod.pbj.event.TickEvent;
import mod.pbj.event.VillagerTradesEvent;
import mod.pbj.feature.Features;
import mod.pbj.feature.SlotFeature;
import mod.pbj.item.AmmoItem;
import mod.pbj.item.FireModeInstance;
import mod.pbj.item.GunItem;
import mod.pbj.item.ThrowableItem;
import mod.pbj.network.ClientBoundPlayerDataSyncPacket;
import mod.pbj.registry.AmmoRegistry;
import mod.pbj.registry.BlockRegistry;
import mod.pbj.registry.DataComponentRegistry;
import mod.pbj.registry.EffectRegistry;
import mod.pbj.registry.ItemRegistry;
import mod.pbj.registry.MiscItemRegistry;
import mod.pbj.registry.VillagerRegistry;
import mod.pbj.util.ClientUtil;
import mod.pbj.util.InventoryUtils;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.ServerTaskScheduler;
import mod.pbj.util.SimpleHitResult;
import mod.pbj.util.Tradeable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CommonEventHandler {
    private final ServerTaskScheduler scheduler;
    private final Random random = new Random();

    public CommonEventHandler(ServerTaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @SubscribeEvent2
    public void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        VillagerRegistry.registerStructures(event.getServer());
    }

    @SubscribeEvent2
    public void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        server.addTickable((Runnable)this.scheduler);
    }

    @SubscribeEvent2
    public void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType() == VillagerRegistry.ARMS_DEALER_PROFESSION.get()) {
            for (Map.Entry<String, Supplier<? extends Item>> e : ItemRegistry.ITEMS.getItemsByName().entrySet()) {
                int emeraldCount;
                List levelTrades;
                Item item = e.getValue().get();
                if (!(item instanceof Tradeable)) continue;
                Tradeable tradeableItem = (Tradeable)item;
                float price = tradeableItem.getPrice();
                int tradeLevel = tradeableItem.getTradeLevel();
                if (Float.isNaN(price) || tradeLevel < 1 || tradeLevel > 5 || (levelTrades = (List)event.getTrades().get(tradeLevel)) == null || (emeraldCount = (int)Math.round((double)price / Config.emeraldExchangeRate)) <= 0) continue;
                VillagerTrades.ItemsForEmeralds ife = new VillagerTrades.ItemsForEmeralds(new ItemStack((ItemLike)item), emeraldCount, tradeableItem.getBundleQuantity(), 16, 1);
                levelTrades.add(ife);
            }
        }
    }

    @SubscribeEvent2
    public void onSwapHands(LivingSwapItemsEvent.Hands event) {
        ItemStack toOffhand = event.getItemSwappedToOffHand();
        if (toOffhand != null && (toOffhand.getItem() instanceof GunItem || toOffhand.getItem() instanceof ThrowableItem)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent2
    public void onLivingDrops(LivingDropsEvent event) {
        float dropChance = (float)Config.itemDropChance;
        if (MiscUtil.isNearlyZero(dropChance)) {
            return;
        }
        float randomNumber = this.random.nextFloat();
        if (event.getEntity() instanceof Monster && randomNumber < dropChance) {
            ItemStack itemStackToDrop = new ItemStack((ItemLike)MiscItemRegistry.GUNMETAL_NUGGET.get(), this.random.nextInt(1, Config.maxItemDropCount));
            ItemEntity drop = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), itemStackToDrop);
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent2
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack itemStack;
        Player mainPlayer;
        if (MiscUtil.isClientSide((Entity)event.player) && event.player != (mainPlayer = ClientUtil.getClientPlayer())) {
            ItemStack itemStack2 = event.player.getMainHandItem();
            GunClientState state = GunClientState.getMainHeldState(event.player);
            if (state != null) {
                state.stateTick((LivingEntity)event.player, itemStack2, false);
            }
        }
        if ((itemStack = event.player.getMainHandItem()) != null && itemStack.getItem() instanceof GunItem) {
            GunClientState state;
            if (GunItem.isAiming(itemStack)) {
                event.player.setSprinting(false);
            }
            if (MiscUtil.isClientSide((Entity)event.player) && (state = GunClientState.getMainHeldState(event.player)) != null && !state.isIdle() && !state.isDrawing()) {
                event.player.setSprinting(false);
            }
        }
    }

    @SubscribeEvent2
    public void onHarvestCheck(PlayerEvent.HarvestCheck check) {
        Player player;
        ItemStack heldItem;
        if (check.getTargetBlock().is(BlockRegistry.PRINTER.get()) && (heldItem = (player = check.getEntity()).getMainHandItem()) != null && heldItem.getItem() instanceof PickaxeItem) {
            check.setCanHarvest(true);
        }
    }

    @SubscribeEvent2
    public void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity;
        if (event.getTo() != null && (event.getTo().getItem() instanceof GunItem || event.getTo().getItem() instanceof ThrowableItem) && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlot() == EquipmentSlot.OFFHAND) {
                ItemStack copy = event.getTo().copy();
                player.getInventory().offhand.clear();
                Vec3 playerPos = event.getEntity().getPosition(0.0f);
                Containers.dropItemStack((Level)MiscUtil.getLevel((Entity)event.getEntity()), (double)playerPos.x, (double)playerPos.y, (double)playerPos.z, (ItemStack)copy);
            }
        }
    }

    @SubscribeEvent2
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = MiscUtil.getLevel((Entity)player);
        if (!level.isClientSide) {
            Platform.getInstance().getNetworkService().sendToClient(new ClientBoundPlayerDataSyncPacket(MiscUtil.getPersistentData(player), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(v -> v != null).map(v -> BuiltInRegistries.ITEM.getId((Object)((Item)v.get()))).collect(Collectors.toList())), player);
        }
    }

    @SubscribeEvent2
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Level level = MiscUtil.getLevel((Entity)player);
        if (!level.isClientSide) {
            Platform.getInstance().getNetworkService().sendToClient(new ClientBoundPlayerDataSyncPacket(MiscUtil.getPersistentData(player), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(v -> v != null).map(v -> BuiltInRegistries.ITEM.getId((Object)((Item)v.get()))).collect(Collectors.toList())), player);
        }
    }

    @SubscribeEvent2
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        Level level = MiscUtil.getLevel((Entity)player);
        if (!level.isClientSide) {
            Platform.getInstance().getNetworkService().sendToClient(new ClientBoundPlayerDataSyncPacket(MiscUtil.getPersistentData(player), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(v -> v != null).map(v -> BuiltInRegistries.ITEM.getId((Object)((Item)v.get()))).collect(Collectors.toList())), player);
        }
    }

    @SubscribeEvent2
    public void onAttachmentRemoved(AttachmentRemovedEvent event) {
        Item maxWeight2;
        ItemStack rootStack = event.getRootStack();
        Player player = event.getPlayer();
        if (player == null || MiscUtil.isClientSide((Entity)player)) {
            return;
        }
        if (!SlotFeature.getSlotContents(rootStack).isEmpty()) {
            ItemStack toDrop;
            CompoundTag tag = (CompoundTag)rootStack.getOrDefault(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)SlotFeature.defaultTag());
            tag = tag.copy();
            int maxWeight2 = 0;
            for (SlotFeature f2 : Features.getEnabledFeatures(rootStack, SlotFeature.class).stream().map(Features.EnabledFeature::feature).map(f -> (SlotFeature)f).toList()) {
                maxWeight2 += f2.maxWeight;
            }
            if (maxWeight2 < 0) {
                maxWeight2 = 0;
            }
            List<ItemStack> contents = SlotFeature.getSlotContents(rootStack);
            for (int currentWeight = SlotFeature.getComputedWeight(rootStack); currentWeight > maxWeight2 && !contents.isEmpty(); currentWeight -= SlotFeature.getItemWeight(toDrop)) {
                toDrop = contents.removeLast();
                Vec3 playerPos = player.getPosition(0.0f);
                Containers.dropItemStack((Level)MiscUtil.getLevel((Entity)player), (double)playerPos.x, (double)playerPos.y, (double)playerPos.z, (ItemStack)toDrop);
                System.out.println("Dropping item due to weight limit: " + String.valueOf(toDrop));
            }
            ListTag items = new ListTag();
            for (ItemStack itemStack : contents) {
                items.add((Object)((Tag)ItemStack.CODEC.encode((Object)itemStack, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow()));
            }
            tag.put("Items", (Tag)items);
            rootStack.set(DataComponentRegistry.SLOT_CONTENTS_COMPONENT.get(), (Object)tag);
        }
        if (!((maxWeight2 = rootStack.getItem()) instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)maxWeight2;
        List<FireModeInstance> fireModeInstances = gunItem.getMainFireModes();
        for (FireModeInstance fireModeInstance : fireModeInstances) {
            int dropCount;
            int maxAmmoCapacity;
            int currentFireModeAmmo = GunItem.getAmmo(rootStack, fireModeInstance);
            int delta = Math.min(currentFireModeAmmo - (maxAmmoCapacity = gunItem.getMaxAmmoCapacity(rootStack, fireModeInstance)), 1728);
            if (delta <= 0) continue;
            List<AmmoItem> actualAmmo = fireModeInstance.getActualAmmo();
            AmmoItem ammoToRemove = null;
            if (actualAmmo.size() == 1) {
                ammoToRemove = actualAmmo.get(0);
            } else if (actualAmmo.size() > 1) {
                AmmoItem creativeAmmo = AmmoRegistry.AMMOCREATIVE.get();
                ammoToRemove = actualAmmo.contains(creativeAmmo) && player.isCreative() ? creativeAmmo : (AmmoItem)actualAmmo.stream().filter(a -> a != creativeAmmo).findAny().orElse(null);
            }
            if (ammoToRemove == null) continue;
            GunItem.setAmmo(rootStack, fireModeInstance, maxAmmoCapacity);
            for (int remainingCount = InventoryUtils.addItem(player, ammoToRemove, delta); remainingCount > 0; remainingCount -= dropCount) {
                dropCount = Math.min(ammoToRemove.getDefaultMaxStackSize(), remainingCount);
                Containers.dropItemStack((Level)MiscUtil.getLevel((Entity)event.getPlayer()), (double)(player.getX() + 1.25), (double)(player.getY() + 1.25), (double)player.getZ(), (ItemStack)new ItemStack((ItemLike)ammoToRemove, dropCount));
            }
        }
    }

    @SubscribeEvent2
    public void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        DamageSource damageSource = event.getSource();
        if (damageSource != null && (entity = damageSource.getEntity()) instanceof Player) {
            LivingEntity lv;
            Entity entity2;
            Player player = (Player)entity;
            if (!MiscUtil.getLevel((Entity)player).isClientSide && (entity2 = event.getSource().getEntity()) instanceof LivingEntity && (lv = (LivingEntity)entity2).getMainHandItem().getItem() instanceof GunItem) {
                LivingEntity targetEntity = event.getEntity();
                List<Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>>> effects = EffectRegistry.getEntityDeathEffects(targetEntity);
                for (Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> supplier : effects) {
                    Vec3 targetPos = targetEntity.getBoundingBox().getCenter();
                    EffectLauncher.broadcast(supplier, player, GunItem.getItemStackId(lv.getMainHandItem()), targetEntity, new SimpleHitResult(targetPos, HitResult.Type.ENTITY, Direction.DOWN, targetEntity.getId()));
                }
            }
        }
    }
}

