/*
 * Decompiled with CFR 0.152.
 */
package com.phone.telephone.world;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PhoneData
extends SavedData {
    private static final String DATA_NAME = "phonemod_data";
    private final Map<String, String> numberToPlayer = new HashMap<String, String>();

    public static PhoneData get(ServerLevel level) {
        DimensionDataStorage storage = level.getServer().overworld().getDataStorage();
        return (PhoneData)storage.computeIfAbsent(new SavedData.Factory(PhoneData::new, PhoneData::load, null), DATA_NAME);
    }

    public static PhoneData load(CompoundTag tag, HolderLookup.Provider provider) {
        PhoneData data = new PhoneData();
        if (tag.contains("Numbers")) {
            CompoundTag numbers = tag.getCompound("Numbers");
            for (String key : numbers.getAllKeys()) {
                data.numberToPlayer.put(key, numbers.getString(key));
            }
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag numbers = new CompoundTag();
        for (Map.Entry<String, String> entry : this.numberToPlayer.entrySet()) {
            numbers.putString(entry.getKey(), entry.getValue());
        }
        tag.put("Numbers", (Tag)numbers);
        return tag;
    }

    public boolean hasNumber(String number) {
        return this.numberToPlayer.containsKey(number);
    }

    public void addNumber(String number, String playerName) {
        this.numberToPlayer.put(number, playerName);
        this.setDirty();
    }

    public String getPlayerName(String number) {
        return this.numberToPlayer.get(number);
    }
}

