/*
 * Decompiled with CFR 0.152.
 */
package com.phone.telephone.voice;

import com.phone.telephone.network.PacketHandler;
import com.phone.telephone.voice.PhoneVoicePlugin;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class CallManager {
    public static void startCall(ServerPlayer player1, ServerPlayer player2) {
        if (PhoneVoicePlugin.voicechatServerApi == null) {
            return;
        }
        String groupName = "Appel " + player1.getGameProfile().getName() + "-" + player2.getGameProfile().getName();
        Group group = PhoneVoicePlugin.voicechatServerApi.groupBuilder().setName(groupName).setPassword(UUID.randomUUID().toString()).setPersistent(false).setType(Group.Type.ISOLATED).build();
        VoicechatConnection conn1 = PhoneVoicePlugin.voicechatServerApi.getConnectionOf(player1.getUUID());
        VoicechatConnection conn2 = PhoneVoicePlugin.voicechatServerApi.getConnectionOf(player2.getUUID());
        if (conn1 != null) {
            conn1.setGroup(group);
        }
        if (conn2 != null) {
            conn2.setGroup(group);
        }
        String name1 = PacketHandler.getPhoneName(player1);
        String number1 = PacketHandler.getPhoneNumber(player1);
        String name2 = PacketHandler.getPhoneName(player2);
        String number2 = PacketHandler.getPhoneNumber(player2);
        PacketDistributor.sendToPlayer((ServerPlayer)player1, (CustomPacketPayload)new PacketHandler.CallStartedPayload(name2, number2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PacketHandler.CallStartedPayload(name1, number1), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void endCall(ServerPlayer player) {
        if (PhoneVoicePlugin.voicechatServerApi == null) {
            return;
        }
        VoicechatConnection conn = PhoneVoicePlugin.voicechatServerApi.getConnectionOf(player.getUUID());
        if (conn != null && conn.getGroup() != null) {
            UUID groupId = conn.getGroup().getId();
            for (ServerPlayer p : player.server.getPlayerList().getPlayers()) {
                VoicechatConnection pConn = PhoneVoicePlugin.voicechatServerApi.getConnectionOf(p.getUUID());
                if (pConn == null || pConn.getGroup() == null || !pConn.getGroup().getId().equals(groupId)) continue;
                pConn.setGroup(null);
                PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new PacketHandler.CallEndedPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

