/*
 * Decompiled with CFR 0.152.
 */
package com.phone.telephone.network;

import com.phone.telephone.Phonemod;
import com.phone.telephone.client.gui.InCallScreen;
import com.phone.telephone.client.gui.IncomingCallScreen;
import com.phone.telephone.voice.CallManager;
import com.phone.telephone.world.PhoneData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="phonemod", bus=EventBusSubscriber.Bus.MOD)
public class PacketHandler {
    public static final CustomPacketPayload.Type<PhoneSetupPayload> PHONE_SETUP_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"phone_setup"));
    public static final CustomPacketPayload.Type<AddContactPayload> ADD_CONTACT_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"add_contact"));
    public static final CustomPacketPayload.Type<RemoveContactPayload> REMOVE_CONTACT_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"remove_contact"));
    public static final CustomPacketPayload.Type<RemoveConversationPayload> REMOVE_CONVERSATION_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"remove_conversation"));
    public static final CustomPacketPayload.Type<SendMessagePayload> SEND_MESSAGE_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"send_message"));
    public static final CustomPacketPayload.Type<CallRequestPayload> CALL_REQUEST_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"call_request"));
    public static final CustomPacketPayload.Type<CallIncomingPayload> CALL_INCOMING_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"call_incoming"));
    public static final CustomPacketPayload.Type<CallAcceptPayload> CALL_ACCEPT_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"call_accept"));
    public static final CustomPacketPayload.Type<CallDenyPayload> CALL_DENY_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"call_deny"));
    public static final CustomPacketPayload.Type<CallStartedPayload> CALL_STARTED_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"call_started"));
    public static final CustomPacketPayload.Type<CallEndPayload> CALL_END_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"call_end"));
    public static final CustomPacketPayload.Type<CallEndedPayload> CALL_ENDED_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"call_ended"));

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(PHONE_SETUP_TYPE, PhoneSetupPayload.STREAM_CODEC, PhoneSetupPayload::handle);
        registrar.playToServer(ADD_CONTACT_TYPE, AddContactPayload.STREAM_CODEC, AddContactPayload::handle);
        registrar.playToServer(REMOVE_CONTACT_TYPE, RemoveContactPayload.STREAM_CODEC, RemoveContactPayload::handle);
        registrar.playToServer(REMOVE_CONVERSATION_TYPE, RemoveConversationPayload.STREAM_CODEC, RemoveConversationPayload::handle);
        registrar.playToServer(SEND_MESSAGE_TYPE, SendMessagePayload.STREAM_CODEC, SendMessagePayload::handle);
        registrar.playToServer(CALL_REQUEST_TYPE, CallRequestPayload.STREAM_CODEC, CallRequestPayload::handle);
        registrar.playToClient(CALL_INCOMING_TYPE, CallIncomingPayload.STREAM_CODEC, CallIncomingPayload::handle);
        registrar.playToServer(CALL_ACCEPT_TYPE, CallAcceptPayload.STREAM_CODEC, CallAcceptPayload::handle);
        registrar.playToServer(CALL_DENY_TYPE, CallDenyPayload.STREAM_CODEC, CallDenyPayload::handle);
        registrar.playToClient(CALL_STARTED_TYPE, CallStartedPayload.STREAM_CODEC, CallStartedPayload::handle);
        registrar.playToServer(CALL_END_TYPE, CallEndPayload.STREAM_CODEC, CallEndPayload::handle);
        registrar.playToClient(CALL_ENDED_TYPE, CallEndedPayload.STREAM_CODEC, CallEndedPayload::handle);
    }

    public static ItemStack getPhoneWithNumber(ServerPlayer player, String number) {
        if (PacketHandler.checkStack(player.getItemInHand(InteractionHand.MAIN_HAND), number)) {
            return player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        if (PacketHandler.checkStack(player.getItemInHand(InteractionHand.OFF_HAND), number)) {
            return player.getItemInHand(InteractionHand.OFF_HAND);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!PacketHandler.checkStack(stack, number)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean hasPhoneWithNumber(ServerPlayer player, String number) {
        return !PacketHandler.getPhoneWithNumber(player, number).isEmpty();
    }

    private static boolean checkStack(ItemStack stack, String number) {
        if (stack.getItem() != Phonemod.PHONE.get()) {
            return false;
        }
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            return false;
        }
        CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
        return tag.contains("PhoneNumber") && tag.getString("PhoneNumber").equals(number);
    }

    public static String getPhoneName(ServerPlayer player) {
        CompoundTag tag;
        ItemStack stack = ItemStack.EMPTY;
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Phonemod.PHONE.get()) {
            stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == Phonemod.PHONE.get()) {
            stack = player.getItemInHand(InteractionHand.OFF_HAND);
        } else {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack s = player.getInventory().getItem(i);
                if (s.getItem() != Phonemod.PHONE.get()) continue;
                stack = s;
                break;
            }
        }
        if (!stack.isEmpty() && stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("PhoneName")) {
            return tag.getString("PhoneName");
        }
        return player.getGameProfile().getName();
    }

    public static String getPhoneNumber(ServerPlayer player) {
        CompoundTag tag;
        ItemStack stack = ItemStack.EMPTY;
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Phonemod.PHONE.get()) {
            stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == Phonemod.PHONE.get()) {
            stack = player.getItemInHand(InteractionHand.OFF_HAND);
        } else {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack s = player.getInventory().getItem(i);
                if (s.getItem() != Phonemod.PHONE.get()) continue;
                stack = s;
                break;
            }
        }
        if (!stack.isEmpty() && stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("PhoneNumber")) {
            return tag.getString("PhoneNumber");
        }
        return "";
    }

    public record PhoneSetupPayload(String name, String number, String password) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, PhoneSetupPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PhoneSetupPayload::name, (StreamCodec)ByteBufCodecs.STRING_UTF8, PhoneSetupPayload::number, (StreamCodec)ByteBufCodecs.STRING_UTF8, PhoneSetupPayload::password, PhoneSetupPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PHONE_SETUP_TYPE;
        }

        public static void handle(PhoneSetupPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ItemStack stack = ItemStack.EMPTY;
                    if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Phonemod.PHONE.get()) {
                        stack = player.getItemInHand(InteractionHand.MAIN_HAND);
                    } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == Phonemod.PHONE.get()) {
                        stack = player.getItemInHand(InteractionHand.OFF_HAND);
                    } else {
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack s = player.getInventory().getItem(i);
                            if (s.getItem() != Phonemod.PHONE.get()) continue;
                            stack = s;
                            break;
                        }
                    }
                    if (!stack.isEmpty()) {
                        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                        tag.putString("PhoneName", payload.name());
                        tag.putString("PhoneNumber", payload.number());
                        tag.putString("PhonePassword", payload.password());
                        tag.putBoolean("PhoneSetup", true);
                        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("T\u00e9l\u00e9phone de " + payload.name())));
                        Level patt1$temp = player.level();
                        if (patt1$temp instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)patt1$temp;
                            PhoneData data = PhoneData.get(serverLevel);
                            data.addNumber(payload.number(), player.getGameProfile().getName());
                            System.out.println("DEBUG: Registered number " + payload.number() + " to player " + player.getGameProfile().getName());
                        }
                    }
                }
            });
        }
    }

    public record AddContactPayload(String name, String number) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, AddContactPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, AddContactPayload::name, (StreamCodec)ByteBufCodecs.STRING_UTF8, AddContactPayload::number, AddContactPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ADD_CONTACT_TYPE;
        }

        public static void handle(AddContactPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                ServerPlayer player;
                Level patt1$temp;
                System.out.println("DEBUG: PacketHandler re\u00e7u pour AddContact: " + payload.name() + " - " + payload.number());
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer && (patt1$temp = (player = (ServerPlayer)patt0$temp).level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt1$temp;
                    ItemStack stack = ItemStack.EMPTY;
                    if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Phonemod.PHONE.get()) {
                        stack = player.getItemInHand(InteractionHand.MAIN_HAND);
                    } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == Phonemod.PHONE.get()) {
                        stack = player.getItemInHand(InteractionHand.OFF_HAND);
                    } else {
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack s = player.getInventory().getItem(i);
                            if (s.getItem() != Phonemod.PHONE.get()) continue;
                            stack = s;
                            break;
                        }
                    }
                    if (!stack.isEmpty()) {
                        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                        CompoundTag contacts = tag.getCompound("Contacts");
                        contacts.putString(payload.name(), payload.number());
                        tag.put("Contacts", (Tag)contacts);
                        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                        player.sendSystemMessage((Component)Component.literal((String)("Contact ajout\u00e9 : " + payload.name())));
                        System.out.println("DEBUG: Contact ajout\u00e9 au NBT du t\u00e9l\u00e9phone");
                    } else {
                        System.out.println("DEBUG: Aucun t\u00e9l\u00e9phone trouv\u00e9 dans l'inventaire du joueur");
                    }
                }
            });
        }
    }

    public record RemoveContactPayload(String name) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, RemoveContactPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, RemoveContactPayload::name, RemoveContactPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REMOVE_CONTACT_TYPE;
        }

        public static void handle(RemoveContactPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                System.out.println("DEBUG: PacketHandler re\u00e7u pour RemoveContact: " + payload.name());
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ItemStack stack = ItemStack.EMPTY;
                    if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Phonemod.PHONE.get()) {
                        stack = player.getItemInHand(InteractionHand.MAIN_HAND);
                    } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == Phonemod.PHONE.get()) {
                        stack = player.getItemInHand(InteractionHand.OFF_HAND);
                    } else {
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack s = player.getInventory().getItem(i);
                            if (s.getItem() != Phonemod.PHONE.get()) continue;
                            stack = s;
                            break;
                        }
                    }
                    if (!stack.isEmpty()) {
                        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                        CompoundTag contacts = tag.getCompound("Contacts");
                        if (contacts.contains(payload.name())) {
                            contacts.remove(payload.name());
                            tag.put("Contacts", (Tag)contacts);
                            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                            player.sendSystemMessage((Component)Component.literal((String)("Contact supprim\u00e9 : " + payload.name())));
                            System.out.println("DEBUG: Contact supprim\u00e9 du NBT du t\u00e9l\u00e9phone");
                        } else {
                            System.out.println("DEBUG: Contact non trouv\u00e9 dans le NBT");
                        }
                    } else {
                        System.out.println("DEBUG: Aucun t\u00e9l\u00e9phone trouv\u00e9 dans l'inventaire du joueur");
                    }
                }
            });
        }
    }

    public record RemoveConversationPayload(String number) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, RemoveConversationPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, RemoveConversationPayload::number, RemoveConversationPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REMOVE_CONVERSATION_TYPE;
        }

        public static void handle(RemoveConversationPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    CompoundTag messages;
                    CompoundTag tag;
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ItemStack stack = ItemStack.EMPTY;
                    if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Phonemod.PHONE.get()) {
                        stack = player.getItemInHand(InteractionHand.MAIN_HAND);
                    } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == Phonemod.PHONE.get()) {
                        stack = player.getItemInHand(InteractionHand.OFF_HAND);
                    } else {
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack s = player.getInventory().getItem(i);
                            if (s.getItem() != Phonemod.PHONE.get()) continue;
                            stack = s;
                            break;
                        }
                    }
                    if (!stack.isEmpty() && (tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains("Messages") && (messages = tag.getCompound("Messages")).contains(payload.number())) {
                        messages.remove(payload.number());
                        tag.put("Messages", (Tag)messages);
                        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                    }
                }
            });
        }
    }

    public record SendMessagePayload(String targetNumber, String content) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, SendMessagePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SendMessagePayload::targetNumber, (StreamCodec)ByteBufCodecs.STRING_UTF8, SendMessagePayload::content, SendMessagePayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return SEND_MESSAGE_TYPE;
        }

        public static void handle(SendMessagePayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                System.out.println("DEBUG: PacketHandler re\u00e7u pour SendMessage: " + payload.targetNumber() + " - " + payload.content());
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ItemStack stack = ItemStack.EMPTY;
                    if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Phonemod.PHONE.get()) {
                        stack = player.getItemInHand(InteractionHand.MAIN_HAND);
                    } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == Phonemod.PHONE.get()) {
                        stack = player.getItemInHand(InteractionHand.OFF_HAND);
                    } else {
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack s = player.getInventory().getItem(i);
                            if (s.getItem() != Phonemod.PHONE.get()) continue;
                            stack = s;
                            break;
                        }
                    }
                    if (!stack.isEmpty()) {
                        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                        CompoundTag messagesTag = tag.getCompound("Messages");
                        ListTag conversation = messagesTag.getList(payload.targetNumber(), 10);
                        CompoundTag msg = new CompoundTag();
                        msg.putString("sender", "me");
                        msg.putString("content", payload.content());
                        msg.putLong("timestamp", System.currentTimeMillis());
                        conversation.add((Object)msg);
                        messagesTag.put(payload.targetNumber(), (Tag)conversation);
                        tag.put("Messages", (Tag)messagesTag);
                        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                        System.out.println("DEBUG: Message sauvegard\u00e9 dans le NBT du t\u00e9l\u00e9phone (Sender)");
                        Level patt1$temp = player.level();
                        if (patt1$temp instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)patt1$temp;
                            String senderNumber = tag.getString("PhoneNumber");
                            String senderName = PacketHandler.getPhoneName(player);
                            boolean delivered = false;
                            for (ServerPlayer targetPlayer : serverLevel.getServer().getPlayerList().getPlayers()) {
                                ItemStack targetStack = PacketHandler.getPhoneWithNumber(targetPlayer, payload.targetNumber());
                                if (targetStack.isEmpty()) continue;
                                CompoundTag targetTag = ((CustomData)targetStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                                CompoundTag targetMessages = targetTag.getCompound("Messages");
                                ListTag targetConversation = targetMessages.getList(senderNumber, 10);
                                CompoundTag receivedMsg = new CompoundTag();
                                receivedMsg.putString("sender", senderNumber);
                                receivedMsg.putString("senderName", senderName);
                                receivedMsg.putString("content", payload.content());
                                receivedMsg.putLong("timestamp", System.currentTimeMillis());
                                targetConversation.add((Object)receivedMsg);
                                targetMessages.put(senderNumber, (Tag)targetConversation);
                                targetTag.put("Messages", (Tag)targetMessages);
                                targetStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)targetTag));
                                targetPlayer.sendSystemMessage((Component)Component.literal((String)("Nouveau message de " + senderName + " (" + senderNumber + ")")));
                                System.out.println("DEBUG: Message livr\u00e9 au joueur " + targetPlayer.getName().getString() + " (Porteur du t\u00e9l\u00e9phone " + payload.targetNumber() + ")");
                                delivered = true;
                                break;
                            }
                            if (!delivered) {
                                System.out.println("DEBUG: Aucun joueur en ligne ne poss\u00e8de le t\u00e9l\u00e9phone " + payload.targetNumber());
                            }
                        }
                    }
                }
            });
        }
    }

    public record CallRequestPayload(String number) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, CallRequestPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CallRequestPayload::number, CallRequestPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CALL_REQUEST_TYPE;
        }

        public static void handle(CallRequestPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer sender = (ServerPlayer)patt0$temp;
                    ServerPlayer target = null;
                    for (ServerPlayer p : sender.server.getPlayerList().getPlayers()) {
                        if (!PacketHandler.hasPhoneWithNumber(p, payload.number())) continue;
                        target = p;
                        break;
                    }
                    if (target != null) {
                        String senderName = PacketHandler.getPhoneName(sender);
                        String senderNumber = PacketHandler.getPhoneNumber(sender);
                        PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)new CallIncomingPayload(senderName, senderNumber, sender.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        sender.sendSystemMessage((Component)Component.literal((String)("Appel en cours vers " + payload.number() + "...")));
                    } else {
                        sender.sendSystemMessage((Component)Component.literal((String)("Le num\u00e9ro " + payload.number() + " est injoignable.")));
                    }
                }
            });
        }
    }

    public record CallIncomingPayload(String callerName, String callerNumber, UUID callerId) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, CallIncomingPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CallIncomingPayload::callerName, (StreamCodec)ByteBufCodecs.STRING_UTF8, CallIncomingPayload::callerNumber, (StreamCodec)UUIDUtil.STREAM_CODEC, CallIncomingPayload::callerId, CallIncomingPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CALL_INCOMING_TYPE;
        }

        public static void handle(CallIncomingPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> Minecraft.getInstance().setScreen((Screen)new IncomingCallScreen(payload.callerName(), payload.callerNumber(), payload.callerId())));
        }
    }

    public record CallAcceptPayload(UUID callerId) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, CallAcceptPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, CallAcceptPayload::callerId, CallAcceptPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CALL_ACCEPT_TYPE;
        }

        public static void handle(CallAcceptPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer receiver = (ServerPlayer)patt0$temp;
                    ServerPlayer caller = receiver.server.getPlayerList().getPlayer(payload.callerId());
                    if (caller != null) {
                        CallManager.startCall(caller, receiver);
                    } else {
                        receiver.sendSystemMessage((Component)Component.literal((String)"L'appelant n'est plus en ligne."));
                    }
                }
            });
        }
    }

    public record CallDenyPayload(UUID callerId) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, CallDenyPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, CallDenyPayload::callerId, CallDenyPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CALL_DENY_TYPE;
        }

        public static void handle(CallDenyPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer receiver = (ServerPlayer)patt0$temp;
                    ServerPlayer caller = receiver.server.getPlayerList().getPlayer(payload.callerId());
                    if (caller != null) {
                        caller.sendSystemMessage((Component)Component.literal((String)("Appel refus\u00e9 par " + receiver.getName().getString())));
                    }
                }
            });
        }
    }

    public record CallStartedPayload(String otherPlayerName, String otherPlayerNumber) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, CallStartedPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CallStartedPayload::otherPlayerName, (StreamCodec)ByteBufCodecs.STRING_UTF8, CallStartedPayload::otherPlayerNumber, CallStartedPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CALL_STARTED_TYPE;
        }

        public static void handle(CallStartedPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> Minecraft.getInstance().setScreen((Screen)new InCallScreen(payload.otherPlayerName(), payload.otherPlayerNumber())));
        }
    }

    public record CallEndPayload() implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, CallEndPayload> STREAM_CODEC = StreamCodec.unit((Object)new CallEndPayload());

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CALL_END_TYPE;
        }

        public static void handle(CallEndPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    CallManager.endCall(player);
                }
            });
        }
    }

    public record CallEndedPayload() implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, CallEndedPayload> STREAM_CODEC = StreamCodec.unit((Object)new CallEndedPayload());

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CALL_ENDED_TYPE;
        }

        public static void handle(CallEndedPayload payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.getInstance();
                if (mc.screen instanceof InCallScreen) {
                    mc.setScreen(null);
                    mc.player.displayClientMessage((Component)Component.literal((String)"Appel termin\u00e9."), true);
                }
            });
        }
    }
}

