/*
 * Decompiled with CFR 0.152.
 */
package com.phone.telephone.client.gui;

import com.phone.telephone.Phonemod;
import com.phone.telephone.client.gui.CallScreen;
import com.phone.telephone.client.gui.ContactsScreen;
import com.phone.telephone.client.gui.IconButton;
import com.phone.telephone.client.gui.MessagesScreen;
import com.phone.telephone.network.PacketHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.network.PacketDistributor;

public class PhoneScreen
extends Screen {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"textures/gui/phone.png");
    private static final ResourceLocation ICON_CONTACTS = ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"textures/gui/icon_contacts.png");
    private static final ResourceLocation ICON_MESSAGES = ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"textures/gui/icon_messages.png");
    private static final ResourceLocation ICON_CALLS = ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"textures/gui/icon_calls.png");
    public static final int WIDTH = 180;
    public static final int HEIGHT = 320;
    private EditBox nameBox;
    private EditBox numberBox;
    private EditBox passwordBox;
    private Button setupButton;
    private boolean isSetup = false;

    public PhoneScreen() {
        super((Component)Component.translatable((String)"screen.phonemod.phone"));
    }

    protected void init() {
        super.init();
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        this.isSetup = false;
        if (this.minecraft != null && this.minecraft.player != null) {
            CompoundTag tag;
            ItemStack stack = ItemStack.EMPTY;
            if (this.minecraft.player.getMainHandItem().getItem() == Phonemod.PHONE.get()) {
                stack = this.minecraft.player.getMainHandItem();
            } else if (this.minecraft.player.getOffhandItem().getItem() == Phonemod.PHONE.get()) {
                stack = this.minecraft.player.getOffhandItem();
            } else {
                for (ItemStack s2 : this.minecraft.player.getInventory().items) {
                    if (s2.getItem() != Phonemod.PHONE.get()) continue;
                    stack = s2;
                    break;
                }
            }
            if (!stack.isEmpty() && stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("PhoneSetup") && tag.getBoolean("PhoneSetup")) {
                this.isSetup = true;
            }
        }
        if (!this.isSetup) {
            int boxWidth = 130;
            int startX = x + (180 - boxWidth) / 2;
            this.nameBox = new EditBox(this.font, startX, y + 100, boxWidth, 20, (Component)Component.literal((String)"Nom"));
            this.nameBox.setMaxLength(20);
            this.addRenderableWidget((GuiEventListener)this.nameBox);
            this.numberBox = new EditBox(this.font, startX, y + 140, boxWidth, 20, (Component)Component.literal((String)"Num\u00e9ro"));
            this.numberBox.setMaxLength(8);
            this.numberBox.setValue("555-");
            this.numberBox.setFilter(s -> s.startsWith("555-") && s.length() <= 8 && s.substring(4).matches("[0-9]*"));
            this.addRenderableWidget((GuiEventListener)this.numberBox);
            this.passwordBox = new EditBox(this.font, startX, y + 180, boxWidth, 20, (Component)Component.literal((String)"Mot de passe"));
            this.passwordBox.setMaxLength(10);
            this.addRenderableWidget((GuiEventListener)this.passwordBox);
            this.setupButton = Button.builder((Component)Component.literal((String)"Configurer"), button -> {
                String name = this.nameBox.getValue();
                String number = this.numberBox.getValue();
                String password = this.passwordBox.getValue();
                if (name.isEmpty() || number.length() != 8 || password.isEmpty()) {
                    return;
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketHandler.PhoneSetupPayload(name, number, password), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.isSetup = true;
                this.rebuildWidgets();
            }).bounds(x + 40, y + 220, 100, 20).build();
            this.addRenderableWidget((GuiEventListener)this.setupButton);
        } else {
            int buttonWidth = 32;
            int buttonHeight = 32;
            int spacing = 20;
            int startX = x + 48;
            int startY = y + 80;
            this.addRenderableWidget((GuiEventListener)new IconButton(startX, startY, buttonWidth, buttonHeight, ICON_CONTACTS, button -> this.minecraft.setScreen((Screen)new ContactsScreen(this))));
            this.addRenderableWidget((GuiEventListener)new IconButton(startX + buttonWidth + spacing, startY, buttonWidth, buttonHeight, ICON_MESSAGES, button -> this.minecraft.setScreen((Screen)new MessagesScreen(this))));
            this.addRenderableWidget((GuiEventListener)new IconButton(startX, startY + buttonHeight + spacing, buttonWidth, buttonHeight, ICON_CALLS, button -> this.minecraft.setScreen((Screen)new CallScreen(this))));
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        guiGraphics.fill(x, y, x + 180, y + 320, -14540254);
        guiGraphics.renderOutline(x, y, 180, 320, -16777216);
        guiGraphics.blit(TEXTURE, x, y, 0.0f, 0.0f, 180, 320, 180, 320);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.isSetup) {
            int startX = x + 25;
            guiGraphics.drawCenteredString(this.font, "Configuration", x + 90, y + 70, 0xFFFFFF);
            guiGraphics.drawString(this.font, "Nom", startX + 5, y + 90, 0xFFFFFF);
            guiGraphics.drawString(this.font, "Num\u00e9ro", startX + 5, y + 130, 0xFFFFFF);
            guiGraphics.drawString(this.font, "Mot de passe", startX + 5, y + 170, 0xFFFFFF);
        } else {
            guiGraphics.drawCenteredString(this.font, "Accueil", x + 90, y + 60, 0xFFFFFF);
            int buttonWidth = 32;
            int buttonHeight = 32;
            int spacing = 20;
            int startX = x + 48;
            int startY = y + 80;
            guiGraphics.drawCenteredString(this.font, "Contact", startX + buttonWidth / 2, startY + buttonHeight + 2, 0xFFFFFF);
            guiGraphics.drawCenteredString(this.font, "Message", startX + buttonWidth + spacing + buttonWidth / 2, startY + buttonHeight + 2, 0xFFFFFF);
            guiGraphics.drawCenteredString(this.font, "Appel", startX + buttonWidth / 2, startY + buttonHeight + spacing + buttonHeight + 2, 0xFFFFFF);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean isPauseScreen() {
        return false;
    }
}

