/*
 * Decompiled with CFR 0.152.
 */
package com.phone.telephone.client.gui;

import com.phone.telephone.Phonemod;
import com.phone.telephone.client.gui.ContactsScreen;
import com.phone.telephone.client.gui.ConversationScreen;
import com.phone.telephone.client.gui.PhoneScreen;
import com.phone.telephone.network.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.network.PacketDistributor;

public class MessagesScreen
extends Screen {
    private final Screen parent;
    private final List<String> conversations = new ArrayList<String>();

    public MessagesScreen(Screen parent) {
        super((Component)Component.translatable((String)"screen.phonemod.messages"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.loadConversations();
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), button -> this.minecraft.setScreen(this.parent)).bounds(x + 30, y + 55, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+"), button -> this.minecraft.setScreen((Screen)new ContactsScreen(this))).bounds(x + 180 - 50, y + 55, 20, 20).build());
    }

    private void loadConversations() {
        CompoundTag tag;
        this.conversations.clear();
        ItemStack stack = this.getPhoneStack();
        if (!stack.isEmpty() && (tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains("Messages")) {
            CompoundTag messagesTag = tag.getCompound("Messages");
            for (String key : messagesTag.getAllKeys()) {
                this.conversations.add(key);
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        guiGraphics.fill(x, y, x + 180, y + 320, -14540254);
        guiGraphics.renderOutline(x, y, 180, 320, -16777216);
        guiGraphics.blit(PhoneScreen.TEXTURE, x, y, 0.0f, 0.0f, 180, 320, 180, 320);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, "Messages", x + 90, y + 60, 0xFFFFFF);
        this.renderConversationList(guiGraphics, x, y, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    private void renderConversationList(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        int startY = y + 85;
        int itemHeight = 24;
        if (this.conversations.isEmpty()) {
            guiGraphics.drawCenteredString(this.font, "Aucune conversation", x + 90, y + 150, 0xAAAAAA);
            return;
        }
        for (int i = 0; i < this.conversations.size(); ++i) {
            String number = this.conversations.get(i);
            int itemY = startY + i * itemHeight;
            boolean isHovered = mouseX >= x + 25 && mouseX <= x + 180 - 25 && mouseY >= itemY && mouseY < itemY + itemHeight;
            int color = isHovered ? -12303292 : -13421773;
            guiGraphics.fill(x + 25, itemY, x + 180 - 25, itemY + itemHeight - 2, color);
            String displayName = this.getContactName(number);
            guiGraphics.drawString(this.font, displayName, x + 30, itemY + 8, 0xFFFFFF);
            boolean isDeleteHovered = mouseX >= x + 180 - 45 && mouseX <= x + 180 - 30 && mouseY >= itemY + 4 && mouseY <= itemY + 16;
            int deleteColor = isDeleteHovered ? -65536 : -5592406;
            guiGraphics.drawString(this.font, "x", x + 180 - 40, itemY + 8, deleteColor);
        }
    }

    private String getContactName(String number) {
        CompoundTag tag;
        ItemStack stack = this.getPhoneStack();
        if (!stack.isEmpty() && stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("Contacts")) {
            CompoundTag contacts = tag.getCompound("Contacts");
            for (String key : contacts.getAllKeys()) {
                if (!contacts.getString(key).equals(number)) continue;
                return key;
            }
        }
        return number;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        int startY = y + 85;
        int itemHeight = 24;
        for (int i = 0; i < this.conversations.size(); ++i) {
            int itemY = startY + i * itemHeight;
            if (mouseX >= (double)(x + 180 - 45) && mouseX <= (double)(x + 180 - 30) && mouseY >= (double)(itemY + 4) && mouseY <= (double)(itemY + 16)) {
                String number = this.conversations.get(i);
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketHandler.RemoveConversationPayload(number), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.conversations.remove(i);
                return true;
            }
            if (!(mouseX >= (double)(x + 25)) || !(mouseX <= (double)(x + 180 - 25)) || !(mouseY >= (double)itemY) || !(mouseY < (double)(itemY + itemHeight))) continue;
            String number = this.conversations.get(i);
            String name = this.getContactName(number);
            this.minecraft.setScreen((Screen)new ConversationScreen(this, number, name));
            return true;
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private ItemStack getPhoneStack() {
        if (this.minecraft.player == null) {
            return ItemStack.EMPTY;
        }
        if (this.minecraft.player.getMainHandItem().getItem() == Phonemod.PHONE.get()) {
            return this.minecraft.player.getMainHandItem();
        }
        if (this.minecraft.player.getOffhandItem().getItem() == Phonemod.PHONE.get()) {
            return this.minecraft.player.getOffhandItem();
        }
        for (ItemStack stack : this.minecraft.player.getInventory().items) {
            if (stack.getItem() != Phonemod.PHONE.get()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

