/*
 * Decompiled with CFR 0.152.
 */
package com.phone.telephone.client.gui;

import com.phone.telephone.Phonemod;
import com.phone.telephone.client.gui.IconButton;
import com.phone.telephone.client.gui.PhoneScreen;
import com.phone.telephone.network.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.network.PacketDistributor;

public class InCallScreen
extends Screen {
    private static final ResourceLocation ICON_END_CALL = ResourceLocation.fromNamespaceAndPath((String)"phonemod", (String)"textures/gui/icon_call_end.png");
    private final String otherPlayerName;
    private final String otherPlayerNumber;
    private final long startTime;

    public InCallScreen(String otherPlayerName, String otherPlayerNumber) {
        super((Component)Component.translatable((String)"screen.phonemod.in_call"));
        this.otherPlayerName = otherPlayerName;
        this.otherPlayerNumber = otherPlayerNumber;
        this.startTime = System.currentTimeMillis();
    }

    protected void init() {
        super.init();
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        this.addRenderableWidget((GuiEventListener)new IconButton(x + 66, y + 210, 48, 48, ICON_END_CALL, button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new PacketHandler.CallEndPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onClose();
        }));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        guiGraphics.fill(x, y, x + 180, y + 320, -14540254);
        guiGraphics.renderOutline(x, y, 180, 320, -16777216);
        guiGraphics.blit(PhoneScreen.TEXTURE, x, y, 0.0f, 0.0f, 180, 320, 180, 320);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        long durationSeconds = (System.currentTimeMillis() - this.startTime) / 1000L;
        String timeString = String.format("%02d:%02d", durationSeconds / 60L, durationSeconds % 60L);
        guiGraphics.drawCenteredString(this.font, "En appel avec", x + 90, y + 60, 0xFFFFFF);
        String displayName = this.getContactName(this.otherPlayerNumber);
        guiGraphics.drawCenteredString(this.font, displayName, x + 90, y + 80, 0x55FF55);
        guiGraphics.drawCenteredString(this.font, timeString, x + 90, y + 120, 0xFFFFFF);
    }

    private String getContactName(String number) {
        CompoundTag tag;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return number;
        }
        ItemStack stack = ItemStack.EMPTY;
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Phonemod.PHONE.get()) {
            stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == Phonemod.PHONE.get()) {
            stack = player.getItemInHand(InteractionHand.OFF_HAND);
        } else {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack s = player.getInventory().getItem(i);
                if (s.getItem() != Phonemod.PHONE.get()) continue;
                stack = s;
                break;
            }
        }
        if (!stack.isEmpty() && stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("Contacts")) {
            CompoundTag contacts = tag.getCompound("Contacts");
            for (String key : contacts.getAllKeys()) {
                if (!contacts.getString(key).equals(number)) continue;
                return key;
            }
        }
        return number;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean isPauseScreen() {
        return false;
    }
}

