/*
 * Decompiled with CFR 0.152.
 */
package com.phone.telephone.client.gui;

import com.phone.telephone.Phonemod;
import com.phone.telephone.client.gui.PhoneScreen;
import com.phone.telephone.network.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConversationScreen
extends Screen {
    private final Screen parent;
    private final String contactNumber;
    private final String contactName;
    private EditBox messageBox;
    private final List<MessageEntry> messages = new ArrayList<MessageEntry>();

    public ConversationScreen(Screen parent, String number, String name) {
        super((Component)Component.translatable((String)"screen.phonemod.conversation", (Object[])new Object[]{name}));
        this.parent = parent;
        this.contactNumber = number;
        this.contactName = name;
    }

    protected void init() {
        super.init();
        this.loadMessages();
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), button -> this.minecraft.setScreen(this.parent)).bounds(x + 30, y + 55, 20, 20).build());
        this.messageBox = new EditBox(this.font, x + 25, y + 320 - 55, 130, 20, (Component)Component.literal((String)"Message"));
        this.messageBox.setMaxLength(50);
        this.addRenderableWidget((GuiEventListener)this.messageBox);
    }

    private void sendMessage() {
        String content = this.messageBox.getValue();
        if (content.isEmpty()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketHandler.SendMessagePayload(this.contactNumber, content), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ItemStack stack = this.getPhoneStack();
        if (!stack.isEmpty()) {
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            CompoundTag messagesTag = tag.getCompound("Messages");
            ListTag conversation = messagesTag.getList(this.contactNumber, 10);
            CompoundTag msg = new CompoundTag();
            msg.putString("sender", "me");
            msg.putString("content", content);
            msg.putLong("timestamp", System.currentTimeMillis());
            conversation.add((Object)msg);
            messagesTag.put(this.contactNumber, (Tag)conversation);
            tag.put("Messages", (Tag)messagesTag);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.loadMessages();
            this.messageBox.setValue("");
        }
    }

    private void loadMessages() {
        CompoundTag messagesTag;
        CompoundTag tag;
        this.messages.clear();
        ItemStack stack = this.getPhoneStack();
        if (!stack.isEmpty() && (tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains("Messages") && (messagesTag = tag.getCompound("Messages")).contains(this.contactNumber)) {
            ListTag conversation = messagesTag.getList(this.contactNumber, 10);
            for (int i = 0; i < conversation.size(); ++i) {
                CompoundTag msg = conversation.getCompound(i);
                this.messages.add(new MessageEntry(msg.getString("sender"), msg.getString("content"), msg.getLong("timestamp")));
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            this.sendMessage();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        guiGraphics.fill(x, y, x + 180, y + 320, -14540254);
        guiGraphics.renderOutline(x, y, 180, 320, -16777216);
        guiGraphics.blit(PhoneScreen.TEXTURE, x, y, 0.0f, 0.0f, 180, 320, 180, 320);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.contactName, x + 90, y + 60, 0xFFFFFF);
        this.renderChatHistory(guiGraphics, x, y);
    }

    private void renderChatHistory(GuiGraphics guiGraphics, int x, int y) {
        int startY = y + 85;
        int chatHeight = 170;
        int maxWidth = 130;
        int currentY = startY;
        for (MessageEntry msg : this.messages) {
            boolean isMe = msg.sender.equals("me");
            List lines = this.font.split((FormattedText)Component.literal((String)msg.content), maxWidth);
            int bubbleHeight = lines.size() * 10 + 8;
            int maxLineWidth = 0;
            for (FormattedCharSequence line : lines) {
                int w = this.font.width(line);
                if (w <= maxLineWidth) continue;
                maxLineWidth = w;
            }
            int bubbleWidth = maxLineWidth + 8;
            int bubbleX = isMe ? x + 180 - bubbleWidth - 25 : x + 25;
            int bgColor = isMe ? -16745780 : -12303292;
            guiGraphics.fill(bubbleX, currentY, bubbleX + bubbleWidth, currentY + bubbleHeight, bgColor);
            int textY = currentY + 4;
            for (FormattedCharSequence line : lines) {
                guiGraphics.drawString(this.font, line, bubbleX + 4, textY, -1);
                textY += 10;
            }
            if ((currentY += bubbleHeight + 4) <= startY + chatHeight) continue;
            break;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private ItemStack getPhoneStack() {
        if (this.minecraft.player == null) {
            return ItemStack.EMPTY;
        }
        if (this.minecraft.player.getMainHandItem().getItem() == Phonemod.PHONE.get()) {
            return this.minecraft.player.getMainHandItem();
        }
        if (this.minecraft.player.getOffhandItem().getItem() == Phonemod.PHONE.get()) {
            return this.minecraft.player.getOffhandItem();
        }
        for (ItemStack stack : this.minecraft.player.getInventory().items) {
            if (stack.getItem() != Phonemod.PHONE.get()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    private record MessageEntry(String sender, String content, long timestamp) {
    }
}

