/*
 * Decompiled with CFR 0.152.
 */
package com.phone.telephone.client.gui;

import com.phone.telephone.Phonemod;
import com.phone.telephone.client.gui.ConversationScreen;
import com.phone.telephone.client.gui.PhoneScreen;
import com.phone.telephone.network.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.network.PacketDistributor;

public class ContactsScreen
extends Screen {
    private final Screen parent;
    private EditBox nameBox;
    private EditBox numberBox;
    private boolean isAddingContact = false;
    private ContactEntry selectedContact = null;
    private final List<ContactEntry> contacts = new ArrayList<ContactEntry>();

    public ContactsScreen(Screen parent) {
        super((Component)Component.translatable((String)"screen.phonemod.contacts"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.loadContacts();
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), button -> {
            if (this.isAddingContact) {
                this.isAddingContact = false;
                this.rebuildWidgets();
            } else if (this.selectedContact != null) {
                this.selectedContact = null;
                this.rebuildWidgets();
            } else {
                this.minecraft.setScreen(this.parent);
            }
        }).bounds(x + 30, y + 55, 20, 20).build());
        if (this.isAddingContact) {
            this.initAddContact(x, y);
        } else if (this.selectedContact != null) {
            this.initContactDetails(x, y);
        } else {
            this.initContactList(x, y);
        }
    }

    private void initAddContact(int x, int y) {
        this.nameBox = new EditBox(this.font, x + 20, y + 100, 140, 20, (Component)Component.literal((String)"Nom"));
        this.nameBox.setMaxLength(16);
        this.nameBox.setHint((Component)Component.literal((String)"Nom du contact"));
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        this.numberBox = new EditBox(this.font, x + 20, y + 130, 140, 20, (Component)Component.literal((String)"Num\u00e9ro"));
        this.numberBox.setMaxLength(16);
        this.numberBox.setValue("555-");
        this.numberBox.setHint((Component)Component.literal((String)"Num\u00e9ro de t\u00e9l\u00e9phone"));
        this.addRenderableWidget((GuiEventListener)this.numberBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Sauvegarder"), button -> {
            String name = this.nameBox.getValue();
            String number = this.numberBox.getValue();
            System.out.println("DEBUG: Tentative de sauvegarde du contact: " + name + " - " + number);
            if (!name.isEmpty() && !number.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketHandler.AddContactPayload(name, number), (CustomPacketPayload[])new CustomPacketPayload[0]);
                System.out.println("DEBUG: Paquet envoy\u00e9 au serveur");
                ItemStack stack = this.getPhoneStack();
                if (!stack.isEmpty()) {
                    CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                    CompoundTag contactsTag = tag.getCompound("Contacts");
                    contactsTag.putString(name, number);
                    tag.put("Contacts", (Tag)contactsTag);
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                    System.out.println("DEBUG: Donn\u00e9es locales mises \u00e0 jour: " + contactsTag.toString());
                } else {
                    System.out.println("DEBUG: Pas de t\u00e9l\u00e9phone trouv\u00e9 pour la mise \u00e0 jour locale");
                }
                this.isAddingContact = false;
                this.rebuildWidgets();
            }
        }).bounds(x + 40, y + 160, 100, 20).build());
    }

    private void initContactDetails(int x, int y) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Appeler"), button -> {}).bounds(x + 40, y + 140, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Message"), button -> {
            if (this.selectedContact != null) {
                this.minecraft.setScreen((Screen)new ConversationScreen(this, this.selectedContact.number, this.selectedContact.name));
            }
        }).bounds(x + 40, y + 170, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Supprimer"), button -> {
            if (this.selectedContact != null) {
                CompoundTag tag;
                CompoundTag contactsTag;
                String name = this.selectedContact.name;
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketHandler.RemoveContactPayload(name), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ItemStack stack = this.getPhoneStack();
                if (!stack.isEmpty() && (contactsTag = (tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).getCompound("Contacts")).contains(name)) {
                    contactsTag.remove(name);
                    tag.put("Contacts", (Tag)contactsTag);
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                }
                this.selectedContact = null;
                this.rebuildWidgets();
            }
        }).bounds(x + 40, y + 200, 100, 20).build());
    }

    private void initContactList(int x, int y) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+"), button -> {
            this.isAddingContact = true;
            this.rebuildWidgets();
        }).bounds(x + 180 - 50, y + 55, 20, 20).build());
    }

    private void loadContacts() {
        this.contacts.clear();
        ItemStack stack = this.getPhoneStack();
        if (!stack.isEmpty()) {
            System.out.println("DEBUG LOAD: Phone found, loading contacts...");
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("Contacts")) {
                CompoundTag contactsTag = tag.getCompound("Contacts");
                for (String key : contactsTag.getAllKeys()) {
                    this.contacts.add(new ContactEntry(key, contactsTag.getString(key)));
                }
            }
        } else {
            System.out.println("DEBUG LOAD: No phone found in inventory!");
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.width - 180 - 10;
        int y = this.height - 320 - 10;
        guiGraphics.fill(x, y, x + 180, y + 320, -14540254);
        guiGraphics.renderOutline(x, y, 180, 320, -16777216);
        guiGraphics.blit(PhoneScreen.TEXTURE, x, y, 0.0f, 0.0f, 180, 320, 180, 320);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        String title = this.isAddingContact ? "Ajouter" : (this.selectedContact != null ? this.selectedContact.name : "Contacts");
        guiGraphics.drawCenteredString(this.font, title, x + 90, y + 60, 0xFFFFFF);
        if (!this.isAddingContact && this.selectedContact == null) {
            this.renderContactList(guiGraphics, x, y, mouseX, mouseY);
        } else if (this.selectedContact != null) {
            this.renderContactDetails(guiGraphics, x, y);
        }
    }

    private void renderContactList(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        int startY = y + 85;
        int itemHeight = 24;
        if (this.contacts.isEmpty()) {
            guiGraphics.drawCenteredString(this.font, "Aucun contact", x + 90, y + 150, 0xAAAAAA);
            return;
        }
        for (int i = 0; i < this.contacts.size(); ++i) {
            ContactEntry contact = this.contacts.get(i);
            int itemY = startY + i * itemHeight;
            boolean isHovered = mouseX >= x + 25 && mouseX <= x + 180 - 25 && mouseY >= itemY && mouseY < itemY + itemHeight;
            int color = isHovered ? -12303292 : -13421773;
            guiGraphics.fill(x + 25, itemY, x + 180 - 25, itemY + itemHeight - 2, color);
            guiGraphics.drawString(this.font, contact.name, x + 30, itemY + 2, 0xFFFFFF);
            guiGraphics.drawString(this.font, contact.number, x + 30, itemY + 12, 0xAAAAAA);
        }
    }

    private void renderContactDetails(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawCenteredString(this.font, this.selectedContact.number, x + 90, y + 100, 0xAAAAAA);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (!this.isAddingContact && this.selectedContact == null) {
            int x = this.width - 180 - 10;
            int y = this.height - 320 - 10;
            int startY = y + 85;
            int itemHeight = 24;
            for (int i = 0; i < this.contacts.size(); ++i) {
                int itemY = startY + i * itemHeight;
                if (!(mouseX >= (double)(x + 25)) || !(mouseX <= (double)(x + 180 - 25)) || !(mouseY >= (double)itemY) || !(mouseY < (double)(itemY + itemHeight))) continue;
                this.selectedContact = this.contacts.get(i);
                this.rebuildWidgets();
                return true;
            }
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    private ItemStack getPhoneStack() {
        if (this.minecraft.player == null) {
            return ItemStack.EMPTY;
        }
        if (this.minecraft.player.getMainHandItem().getItem() == Phonemod.PHONE.get()) {
            return this.minecraft.player.getMainHandItem();
        }
        if (this.minecraft.player.getOffhandItem().getItem() == Phonemod.PHONE.get()) {
            return this.minecraft.player.getOffhandItem();
        }
        for (ItemStack stack : this.minecraft.player.getInventory().items) {
            if (stack.getItem() != Phonemod.PHONE.get()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private record ContactEntry(String name, String number) {
    }
}

