/*
 * Decompiled with CFR 0.152.
 */
package com.phone.telephone;

import com.mojang.blaze3d.platform.InputConstants;
import com.phone.telephone.Phonemod;
import com.phone.telephone.client.gui.PhoneScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;

@Mod(value="phonemod", dist={Dist.CLIENT})
@EventBusSubscriber(modid="phonemod", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class PhonemodClient {
    public static final KeyMapping OPEN_PHONE_KEY = new KeyMapping("key.phonemod.open_phone", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 80, "key.categories.phonemod");

    public PhonemodClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(OPEN_PHONE_KEY);
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        Phonemod.LOGGER.info("HELLO FROM CLIENT SETUP");
        Phonemod.LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
    }

    @EventBusSubscriber(modid="phonemod", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    public static class ClientEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (OPEN_PHONE_KEY.consumeClick()) {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.player != null) {
                    boolean hasPhone = false;
                    for (int i = 0; i < minecraft.player.getInventory().getContainerSize(); ++i) {
                        if (minecraft.player.getInventory().getItem(i).getItem() != Phonemod.PHONE.get()) continue;
                        hasPhone = true;
                        break;
                    }
                    if (hasPhone) {
                        minecraft.setScreen((Screen)new PhoneScreen());
                    }
                }
            }
        }
    }
}

