/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.holder;

import dev.latvian.mods.kubejs.core.RegistryObjectKJS;
import dev.latvian.mods.kubejs.holder.NamespaceHolderSet;
import dev.latvian.mods.kubejs.holder.RegExHolderSet;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.holdersets.OrHolderSet;
import org.jetbrains.annotations.Nullable;

public interface HolderWrapper {
    public static final TypeInfo HOLDER = TypeInfo.of(Holder.class);
    public static final TypeInfo HOLDER_SET = TypeInfo.of(HolderSet.class);

    public static Holder<?> wrap(KubeJSContext cx, Object from, TypeInfo param) {
        if (from instanceof Holder) {
            Holder h = (Holder)from;
            return h;
        }
        if (from == null) {
            throw Context.reportRuntimeError((String)"Can't interpret 'null' as a Holder", (Context)cx);
        }
        Registry<?> registry = cx.lookupRegistry(param, from);
        if (!ID.isKey(from)) {
            Class<?> baseClass;
            Holder h = registry.wrapAsHolder(Cast.to(from));
            if (h instanceof Holder.Direct && !(baseClass = cx.lookupRegistryType(param, from).baseClass()).isInstance(from)) {
                throw Context.reportRuntimeError((String)("Can't interpret '" + String.valueOf(from) + "' as Holder: can't cast object to '" + baseClass.getName() + "' of " + String.valueOf(registry.key().location())), (Context)cx);
            }
            return h;
        }
        ResourceLocation id = ID.mc(from);
        Optional holder = registry.getHolder(id);
        return holder.isEmpty() ? DeferredHolder.create((ResourceKey)registry.key(), (ResourceLocation)id) : (Holder)holder.get();
    }

    public static HolderSet<?> wrapSet(KubeJSContext cx, Object from, TypeInfo param) {
        Registry<?> registry = cx.lookupRegistry(param, from);
        HolderSet<?> simpleHolders = HolderWrapper.wrapSimpleSet(registry, from);
        if (simpleHolders != null) {
            return simpleHolders;
        }
        if (from instanceof Iterable) {
            Iterable itr = (Iterable)from;
            Stream.Builder<HolderSet.Direct> allDirects = Stream.builder();
            ArrayList<Object> complex = new ArrayList<Object>();
            for (Object elem : itr) {
                HolderSet<?> wrapped = HolderWrapper.wrapSet(cx, elem, param);
                if (wrapped instanceof HolderSet.Direct) {
                    HolderSet.Direct direct = (HolderSet.Direct)wrapped;
                    allDirects.accept(direct);
                    continue;
                }
                complex.add(wrapped);
            }
            List compressedDirects = allDirects.build().flatMap(HolderSet::stream).distinct().toList();
            if (compressedDirects.isEmpty()) {
                return switch (complex.size()) {
                    case 0 -> HolderSet.empty();
                    case 1 -> (HolderSet)complex.getFirst();
                    default -> new OrHolderSet(complex);
                };
            }
            if (complex.isEmpty()) {
                return HolderSet.direct(compressedDirects);
            }
            complex.add(HolderSet.direct(compressedDirects));
            return new OrHolderSet(complex);
        }
        Holder holder = (Holder)cx.jsToJava(from, HOLDER.withParams(new TypeInfo[]{param}));
        return HolderSet.direct((Holder[])new Holder[]{holder});
    }

    @Nullable
    public static <T> HolderSet<T> wrapSimpleSet(Registry<T> registry, Object from) {
        Object object;
        Object object2 = from;
        int n = 0;
        block17: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HolderSet.class, Holder.class, NativeRegExp.class, Pattern.class, RegistryObjectKJS.class, TagKey.class, ResourceKey.class, ResourceLocation.class, CharSequence.class, CharSequence.class}, (Object)object2, n)) {
                case 0: {
                    HolderSet set;
                    object = set = (HolderSet)object2;
                    break block17;
                }
                case 1: {
                    Holder holder = (Holder)object2;
                    if (!holder.canSerializeIn(registry.holderOwner())) {
                        n = 2;
                        continue block17;
                    }
                    object = HolderSet.direct((Holder[])new Holder[]{holder});
                    break block17;
                }
                case 2: {
                    NativeRegExp regex = (NativeRegExp)object2;
                    object = new RegExHolderSet(registry.asLookup(), RegExpKJS.wrap(regex));
                    break block17;
                }
                case 3: {
                    Pattern regex = (Pattern)object2;
                    object = new RegExHolderSet(registry.asLookup(), regex);
                    break block17;
                }
                case 4: {
                    RegistryObjectKJS registered = (RegistryObjectKJS)object2;
                    object = HolderWrapper.wrapSimpleSet(registry, registered.kjs$asHolder());
                    break block17;
                }
                case 5: {
                    TagKey tag = (TagKey)object2;
                    if (!tag.isFor(registry.key())) {
                        n = 6;
                        continue block17;
                    }
                    object = HolderWrapper.orEmpty(registry.getTag(tag));
                    break block17;
                }
                case 6: {
                    ResourceKey key = (ResourceKey)object2;
                    if (!key.isFor(registry.key())) {
                        n = 7;
                        continue block17;
                    }
                    object = HolderWrapper.orEmpty(key.cast(registry.key()).flatMap(arg_0 -> registry.getHolder(arg_0)).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})));
                    break block17;
                }
                case 7: {
                    ResourceLocation id2 = (ResourceLocation)object2;
                    object = HolderWrapper.orEmpty(registry.getHolder(id2).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})));
                    break block17;
                }
                case 8: {
                    CharSequence cs = (CharSequence)object2;
                    if (!cs.isEmpty()) {
                        n = 9;
                        continue block17;
                    }
                    object = HolderSet.empty();
                    break block17;
                }
                case 9: {
                    CharSequence cs = (CharSequence)object2;
                    String s = cs.toString();
                    switch (s.charAt(0)) {
                        case '@': {
                            object = new NamespaceHolderSet(registry.asLookup(), s.substring(1));
                            break block17;
                        }
                        case '#': {
                            TagKey tagKey = TagKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.parse((String)s.substring(1)));
                            object = registry.getOrCreateTag(tagKey);
                            break block17;
                        }
                        case '/': {
                            object = HolderWrapper.wrapSimpleSet(registry, RegExpKJS.wrap(from));
                            break block17;
                        }
                    }
                    object = ResourceLocation.read((String)s).result().map(id -> HolderWrapper.wrapSimpleSet(registry, id)).orElse(null);
                    break block17;
                }
                default: {
                    object = null;
                    break block17;
                }
            }
            break;
        }
        return object;
    }

    private static <T> HolderSet<T> orEmpty(Optional<? extends HolderSet<T>> holder) {
        return holder.orElse(HolderSet.empty());
    }
}

