/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.core.NoMixinException;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.FluidMatch;
import dev.latvian.mods.kubejs.util.WithCodec;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

@RemapPrefixForJS(value="kjs$")
public interface FluidIngredientKJS
extends WithCodec,
FluidMatch {
    default public FluidIngredient kjs$self() {
        throw new NoMixinException();
    }

    @Override
    default public Codec<?> getCodec(Context cx) {
        return FluidIngredient.CODEC;
    }

    default public SizedFluidIngredient kjs$asBucket() {
        if (this.kjs$self().isEmpty()) {
            return FluidWrapper.EMPTY_SIZED;
        }
        return new SizedFluidIngredient(this.kjs$self(), 1000);
    }

    default public SizedFluidIngredient kjs$withAmount(int amount) {
        return new SizedFluidIngredient(this.kjs$self(), amount);
    }

    @Override
    default public boolean matches(RecipeMatchContext cx, FluidStack s, boolean exact) {
        return !s.isEmpty() && ((FluidIngredient)this).test(s);
    }

    @Override
    default public boolean matches(RecipeMatchContext cx, FluidIngredient in, boolean exact) {
        if (in == FluidIngredient.empty()) {
            return false;
        }
        try {
            for (FluidStack stack : ((FluidIngredient)this).getStacks()) {
                if (!in.test(stack)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            throw new KubeRuntimeException("Failed to test fluid ingredient " + String.valueOf(in), ex);
        }
        return false;
    }
}

