/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.data;

import com.progwml6.ironchest.common.block.IronChestsBlocks;
import com.progwml6.ironchest.common.item.IronChestsItems;
import com.progwml6.ironchest.common.item.IronChestsUpgradeType;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.registries.DeferredItem;

public class IronChestsRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public IronChestsRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.addChestsRecipes(recipeOutput);
        this.addUpgradesRecipes(recipeOutput);
    }

    private void addChestsRecipes(RecipeOutput recipeOutput) {
        String folder = "chests/";
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.COPPER_CHEST.get())).define(Character.valueOf('M'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('S'), Tags.Items.CHESTS_WOODEN).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_copper_ingot", IronChestsRecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "vanilla_copper_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.IRON_CHEST.get())).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.CHESTS_WOODEN).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_iron_ingot", IronChestsRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "vanilla_iron_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.IRON_CHEST.get())).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)IronChestsBlocks.COPPER_CHEST.get()).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("MGM").pattern("GSG").pattern("MGM").unlockedBy("has_iron_ingot", IronChestsRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "copper_iron_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.GOLD_CHEST.get())).define(Character.valueOf('M'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('S'), (ItemLike)IronChestsBlocks.IRON_CHEST.get()).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_gold_ingot", IronChestsRecipeProvider.has((TagKey)Tags.Items.INGOTS_GOLD)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "iron_gold_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.DIAMOND_CHEST.get())).define(Character.valueOf('M'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('S'), (ItemLike)IronChestsBlocks.GOLD_CHEST.get()).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("GGG").pattern("MSM").pattern("GGG").unlockedBy("has_diamonds", IronChestsRecipeProvider.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "gold_diamond_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.OBSIDIAN_CHEST.get())).define(Character.valueOf('M'), (ItemLike)Blocks.OBSIDIAN).define(Character.valueOf('S'), (ItemLike)IronChestsBlocks.DIAMOND_CHEST.get()).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_obsidian", IronChestsRecipeProvider.has((ItemLike)Blocks.OBSIDIAN)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "diamond_obsidian_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.CRYSTAL_CHEST.get())).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('S'), (ItemLike)IronChestsBlocks.DIAMOND_CHEST.get()).pattern("GGG").pattern("GSG").pattern("GGG").unlockedBy("has_glass", IronChestsRecipeProvider.has((TagKey)Tags.Items.GLASS_BLOCKS)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "diamond_crystal_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.DIRT_CHEST.get())).define(Character.valueOf('M'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DIRT, Blocks.COARSE_DIRT, Blocks.PODZOL})).define(Character.valueOf('S'), Tags.Items.CHESTS_WOODEN).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_iron_ingot", IronChestsRecipeProvider.has((ItemLike)Blocks.DIRT)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "vanilla_dirt_chest"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_IRON_CHEST.get())).requires((ItemLike)IronChestsBlocks.IRON_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", IronChestsRecipeProvider.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "trapped_iron_chest"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_GOLD_CHEST.get())).requires((ItemLike)IronChestsBlocks.GOLD_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", IronChestsRecipeProvider.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "trapped_gold_chest"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_DIAMOND_CHEST.get())).requires((ItemLike)IronChestsBlocks.DIAMOND_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", IronChestsRecipeProvider.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "trapped_diamond_chest"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_COPPER_CHEST.get())).requires((ItemLike)IronChestsBlocks.COPPER_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", IronChestsRecipeProvider.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "trapped_copper_chest"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_CRYSTAL_CHEST.get())).requires((ItemLike)IronChestsBlocks.CRYSTAL_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", IronChestsRecipeProvider.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "trapped_crystal_chest"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_OBSIDIAN_CHEST.get())).requires((ItemLike)IronChestsBlocks.OBSIDIAN_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", IronChestsRecipeProvider.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "trapped_obsidian_chest"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_DIRT_CHEST.get())).requires((ItemLike)IronChestsBlocks.DIRT_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", IronChestsRecipeProvider.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(recipeOutput, IronChestsRecipeProvider.location(folder + "trapped_dirt_chest"));
    }

    private void addUpgradesRecipes(RecipeOutput recipeOutput) {
        String folder = "upgrades/";
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.WOOD_TO_COPPER)).get())).define(Character.valueOf('M'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('P'), ItemTags.PLANKS).pattern("MMM").pattern("MPM").pattern("MMM").unlockedBy("has_copper_ingot", IronChestsRecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput, IronChestsRecipeProvider.prefix((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.WOOD_TO_COPPER)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.WOOD_TO_IRON)).get())).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), ItemTags.PLANKS).pattern("MMM").pattern("MPM").pattern("MMM").unlockedBy("has_iron_ingot", IronChestsRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, IronChestsRecipeProvider.prefix((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.WOOD_TO_IRON)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.COPPER_TO_IRON)).get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("IGI").pattern("GCG").pattern("IGI").unlockedBy("has_iron_ingot", IronChestsRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, IronChestsRecipeProvider.prefix((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.COPPER_TO_IRON)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.IRON_TO_GOLD)).get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).pattern("GGG").pattern("GIG").pattern("GGG").unlockedBy("has_iron_ingot", IronChestsRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, IronChestsRecipeProvider.prefix((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.IRON_TO_GOLD)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.GOLD_TO_DIAMOND)).get())).define(Character.valueOf('M'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('S'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("GGG").pattern("MSM").pattern("GGG").unlockedBy("has_glass", IronChestsRecipeProvider.has((TagKey)Tags.Items.GLASS_BLOCKS)).save(recipeOutput, IronChestsRecipeProvider.prefix((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.GOLD_TO_DIAMOND)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.DIAMOND_TO_OBSIDIAN)).get())).define(Character.valueOf('M'), (ItemLike)Blocks.OBSIDIAN).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("MMM").pattern("MGM").pattern("MMM").unlockedBy("has_glass", IronChestsRecipeProvider.has((TagKey)Tags.Items.GLASS_BLOCKS)).save(recipeOutput, IronChestsRecipeProvider.prefix((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.DIAMOND_TO_OBSIDIAN)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.DIAMOND_TO_CRYSTAL)).get())).define(Character.valueOf('M'), (ItemLike)Blocks.OBSIDIAN).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("GGG").pattern("GMG").pattern("GGG").unlockedBy("has_glass", IronChestsRecipeProvider.has((TagKey)Tags.Items.GLASS_BLOCKS)).save(recipeOutput, IronChestsRecipeProvider.prefix((ItemLike)((DeferredItem)IronChestsItems.UPGRADES.get((Object)IronChestsUpgradeType.DIAMOND_TO_CRYSTAL)).get(), folder));
    }

    protected static ResourceLocation prefix(ItemLike item, String prefix) {
        ResourceLocation registryName = BuiltInRegistries.ITEM.getResourceKey((Object)item.asItem()).map(ResourceKey::location).orElseThrow(() -> new IllegalStateException("Could not retrieve registry name for output."));
        return IronChestsRecipeProvider.location(prefix + registryName.getPath());
    }

    private static ResourceLocation location(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)id);
    }

    private static TagKey<Item> tag(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)name));
    }
}

