/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.hiddennames.data;

import github.pitbox46.hiddennames.HiddenNames;
import github.pitbox46.hiddennames.data.Animation;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.RandomStringUtils;

public class Animations {
    public static final DeferredRegister<Animation> ANIMATIONS = DeferredRegister.create(HiddenNames.ANIMATION_REGISTRY, (String)"hiddennames");
    public static final Supplier<Animation> NO_ANIMATION = Animations.register("null", input -> new Animation.Return(input.displayName(), true));
    public static final Supplier<Animation> HIDDEN = Animations.register("hidden", input -> new Animation.Return(input.ogName(), false));
    public static final Supplier<Animation> BREATHE = Animations.register("breathe", input -> {
        int amp = 60;
        int cycle = 180;
        Component displayName = input.displayName();
        TextColor color = displayName.getStyle().getColor();
        if (color == null) {
            color = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE);
        }
        int primaryColor = color.getValue();
        int red = FastColor.ARGB32.red((int)primaryColor);
        int green = FastColor.ARGB32.green((int)primaryColor);
        int blue = FastColor.ARGB32.blue((int)primaryColor);
        double sin = Math.sin((double)(input.tick() % 360L * 2L) * Math.PI / (double)cycle);
        double newRed = (double)red + (double)amp * sin;
        double newGreen = (double)green + (double)amp * sin;
        double newBlue = (double)blue + (double)amp * sin;
        MutableComponent newName = displayName.copy();
        newName.setStyle(displayName.getStyle().withColor(TextColor.fromRgb((int)FastColor.ARGB32.color((int)255, (int)Animations.roundToByte(newRed), (int)Animations.roundToByte(newGreen), (int)Animations.roundToByte(newBlue)))));
        return new Animation.Return((Component)newName, true);
    });
    public static final Supplier<Animation> RAINBOW = Animations.register("rainbow", input -> {
        Component displayName = input.displayName();
        MutableComponent newName = Component.literal((String)"");
        int i = 0;
        for (char c : displayName.getString().toCharArray()) {
            newName.append((Component)Component.literal((String)String.valueOf(c)).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)Mth.hsvToRgb((float)((float)((input.tick() + (long)(3 * i)) % 180L) / 180.0f), (float)1.0f, (float)1.0f)))));
            ++i;
        }
        return new Animation.Return((Component)newName, true);
    });
    public static final Supplier<Animation> CYCLE = Animations.register("cycle", input -> {
        Component displayName = input.displayName();
        int toNext = 80;
        Random rng = new Random(input.player().getId());
        IntStream stream = rng.ints();
        TextColor color1 = TextColor.fromRgb((int)stream.skip(input.tick() / (long)toNext).findFirst().orElseThrow());
        TextColor color2 = TextColor.fromRgb((int)rng.nextInt());
        MutableComponent newName = displayName.copy();
        newName.setStyle(newName.getStyle().withColor(Animations.blendColors(color1, color2, (float)((long)toNext - input.tick() % (long)toNext) / (float)toNext)));
        return new Animation.Return((Component)newName, true);
    });
    public static final Supplier<Animation> RANDOM = Animations.register("random", input -> {
        int toNext = 15;
        Random rng = new Random((long)input.player().getId() * (input.tick() / (long)toNext));
        String name = RandomStringUtils.random((int)rng.nextInt(3, 10), (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)rng);
        MutableComponent newName = Component.literal((String)"");
        for (char c : name.toCharArray()) {
            newName.append((Component)Component.literal((String)String.valueOf(c)).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)rng.nextInt()))));
        }
        return new Animation.Return((Component)newName, true);
    });

    public static Supplier<Animation> register(String name, Function<Animation.Input, Animation.Return> renderer) {
        return ANIMATIONS.register(name, () -> new Animation(ResourceLocation.fromNamespaceAndPath((String)"hiddennames", (String)name), renderer));
    }

    private static int roundToByte(double number) {
        if (number < 0.0) {
            return 0;
        }
        if (number > 255.0) {
            return 255;
        }
        return (int)Math.round(number);
    }

    private static TextColor blendColors(TextColor primary, TextColor secondary, float percent) {
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        int red = (int)((float)FastColor.ARGB32.red((int)primary.getValue()) * percent + (float)FastColor.ARGB32.red((int)secondary.getValue()) * (1.0f - percent));
        int green = (int)((float)FastColor.ARGB32.green((int)primary.getValue()) * percent + (float)FastColor.ARGB32.green((int)secondary.getValue()) * (1.0f - percent));
        int blue = (int)((float)FastColor.ARGB32.blue((int)primary.getValue()) * percent + (float)FastColor.ARGB32.blue((int)secondary.getValue()) * (1.0f - percent));
        return TextColor.fromRgb((int)FastColor.ARGB32.color((int)255, (int)red, (int)green, (int)blue));
    }
}

