/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.hiddennames.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import github.pitbox46.hiddennames.Config;
import github.pitbox46.hiddennames.commands.AnimationArgument;
import github.pitbox46.hiddennames.data.Animation;
import github.pitbox46.hiddennames.data.NameData;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandSetName {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        return CommandSetName.buildSetName(Commands.literal((String)"setName").requires(cs -> cs.hasPermission(((Integer)Config.CHANGE_OWN_NAME_LEVEL.get()).intValue())), ctx -> ((CommandSourceStack)ctx.getSource()).getPlayer() == null ? Collections.emptySet() : Collections.singleton(((CommandSourceStack)ctx.getSource()).getPlayer()), context).then(CommandSetName.buildSetName(Commands.argument((String)"players1", (ArgumentType)EntityArgument.players()).requires(cs -> cs.hasPermission(2)), ctx -> {
            try {
                return EntityArgument.getPlayers((CommandContext)ctx, (String)"players1");
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }, context));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> buildSetName(ArgumentBuilder<CommandSourceStack, ?> builder, Function<CommandContext<CommandSourceStack>, Collection<ServerPlayer>> getPlayers, CommandBuildContext context) {
        return builder.then(Commands.argument((String)"color1", (ArgumentType)ColorArgument.color()).then(Commands.argument((String)"animation1", (ArgumentType)AnimationArgument.animationArgument()).then(Commands.argument((String)"name1", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)context)).executes(ctx -> {
            for (Player player : (Collection)getPlayers.apply(ctx)) {
                MutableComponent displayName = ((Component)ctx.getArgument("name1", Component.class)).copy().withStyle((ChatFormatting)ctx.getArgument("color1", ChatFormatting.class));
                NameData.DATA.put(player.getUUID(), new NameData(player.getUUID(), (Component)displayName, (Animation)ctx.getArgument("animation1", Animation.class)));
            }
            NameData.sendSyncData();
            return 0;
        })))).then(Commands.literal((String)"name").then(Commands.argument((String)"name1", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)context)).executes(ctx -> {
            for (Player player : (Collection)getPlayers.apply(ctx)) {
                Component previous = NameData.DATA.get(player.getUUID()).getDisplayName();
                MutableComponent newName = ((Component)ctx.getArgument("name1", Component.class)).plainCopy().withStyle(previous.getStyle());
                NameData.DATA.get(player.getUUID()).setDisplayName((Component)newName);
            }
            NameData.sendSyncData();
            return 0;
        }))).then(Commands.literal((String)"color").then(Commands.argument((String)"color1", (ArgumentType)ColorArgument.color()).executes(ctx -> {
            for (Player player : (Collection)getPlayers.apply(ctx)) {
                Component previous = NameData.DATA.get(player.getUUID()).getDisplayName();
                MutableComponent newName = Component.literal((String)previous.getString()).withStyle((ChatFormatting)ctx.getArgument("color1", ChatFormatting.class));
                NameData.DATA.get(player.getUUID()).setDisplayName((Component)newName);
            }
            NameData.sendSyncData();
            return 0;
        }))).then(Commands.literal((String)"animation").then(Commands.argument((String)"animation1", (ArgumentType)AnimationArgument.animationArgument()).executes(ctx -> {
            for (Player player : (Collection)getPlayers.apply(ctx)) {
                NameData.DATA.get(player.getUUID()).setAnimation((Animation)ctx.getArgument("animation1", Animation.class));
            }
            NameData.sendSyncData();
            return 0;
        }))).then(Commands.literal((String)"reset").executes(ctx -> {
            for (Player player : (Collection)getPlayers.apply(ctx)) {
                NameData.DATA.put(player.getUUID(), new NameData(player));
            }
            NameData.sendSyncData();
            return 0;
        }));
    }
}

