/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.hiddennames;

import com.mojang.brigadier.CommandDispatcher;
import github.pitbox46.hiddennames.ClientEvents;
import github.pitbox46.hiddennames.Config;
import github.pitbox46.hiddennames.JsonData;
import github.pitbox46.hiddennames.ServerEvents;
import github.pitbox46.hiddennames.commands.AnimationArgument;
import github.pitbox46.hiddennames.commands.ModCommands;
import github.pitbox46.hiddennames.data.Animation;
import github.pitbox46.hiddennames.data.Animations;
import github.pitbox46.hiddennames.network.BlocksHidePacket;
import github.pitbox46.hiddennames.network.ClientPayloadHandler;
import github.pitbox46.hiddennames.network.NameDataSyncPacket;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.handling.MainThreadPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="hiddennames")
public class HiddenNames {
    public static final String MODID = "hiddennames";
    private static final Logger LOGGER = LogManager.getLogger();
    public static JsonData JSON;
    public static final ResourceKey<Registry<Animation>> ANIMATION_REGISTRY_KEY;
    public static final Registry<Animation> ANIMATION_REGISTRY;
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> ARG_TYPE_INFO_REG;
    public static final Supplier<ArgumentTypeInfo<AnimationArgument, SingletonArgumentInfo.Template>> ANIMATION_ARG;

    public HiddenNames(IEventBus modEventBus, ModContainer container) {
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register(ServerEvents.class);
        container.getEventBus().addListener(event -> ClientEvents.onClientSetup(event, container));
        container.getEventBus().addListener(this::registerPackets);
        container.getEventBus().addListener(this::registerRegistries);
        ARG_TYPE_INFO_REG.register(container.getEventBus());
        Animations.ANIMATIONS.register(container.getEventBus());
    }

    public void registerRegistries(NewRegistryEvent event) {
        event.register(ANIMATION_REGISTRY);
    }

    public void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        registrar.playToClient(BlocksHidePacket.TYPE, BlocksHidePacket.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(ClientPayloadHandler::handle));
        registrar.playToClient(NameDataSyncPacket.TYPE, NameDataSyncPacket.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(ClientPayloadHandler::handle));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public static MutableComponent getCorrectedName(Component name, @Nullable Team team) {
        ChatFormatting color;
        MutableComponent nameCopy = name.copy();
        if (((Boolean)Config.TEAM_OVERRIDE.get()).booleanValue() && team != null && (color = team.getColor()) != ChatFormatting.RESET) {
            nameCopy = nameCopy.withColor(color.getColor().intValue());
        }
        return nameCopy;
    }

    public static Component getFullNameplate(Component name, @Nullable Team team) {
        if (team instanceof PlayerTeam) {
            PlayerTeam playerTeam = (PlayerTeam)team;
            ChatFormatting chatformatting = team.getColor();
            MutableComponent prefix = playerTeam.getPlayerPrefix().copy();
            MutableComponent suffix = playerTeam.getPlayerSuffix().copy();
            if (chatformatting != ChatFormatting.RESET) {
                prefix.withStyle(chatformatting);
                suffix.withStyle(chatformatting);
            }
            return Component.empty().append((Component)prefix).append(name).append((Component)suffix);
        }
        return name;
    }

    static {
        ANIMATION_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"animations"));
        ANIMATION_REGISTRY = new RegistryBuilder(ANIMATION_REGISTRY_KEY).sync(true).defaultKey(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"null")).create();
        ARG_TYPE_INFO_REG = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)MODID);
        ANIMATION_ARG = ARG_TYPE_INFO_REG.register("animation_arg", () -> ArgumentTypeInfos.registerByClass(AnimationArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(AnimationArgument::animationArgument)));
    }
}

