/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.admin;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftblibrary.util.PlayerDisplayNameUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class NicknameForCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.NICK.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return Collections.singletonList((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nicknamefor").requires(FTBEConfig.NICK.enabledAndOp())).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(context -> this.nicknameFor((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), ""))).then(((RequiredArgumentBuilder)Commands.argument((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).requires(source -> source.hasPermission(2))).executes(context -> this.nicknameFor((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"nickname"))))));
    }

    public int nicknameFor(CommandSourceStack source, ServerPlayer player, String nick) {
        if (nick.length() > 30) {
            player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.nick.too_long"), false);
            return 0;
        }
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            data.setNick(nick.trim());
            data.markDirty();
            PlayerDisplayNameUtil.refreshDisplayName((Player)player);
            if (data.getNick().isEmpty()) {
                source.sendSuccess(() -> Component.translatable((String)"ftbessentials.nick.reset"), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"ftbessentials.nick.changed", (Object[])new Object[]{data.getNick()}), true);
            }
            data.sendTabName(source.getServer());
            return 1;
        }).orElse(0);
    }
}

