/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CameraStandItem
extends Item {
    public CameraStandItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Direction direction = context.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(context);
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        ItemStack itemStack = context.getItemInHand();
        Vec3 pos = Vec3.atBottomCenterOf((Vec3i)blockPos);
        AABB aabb = Exposure.EntityTypes.CAMERA_STAND.get().getDimensions().makeBoundingBox(pos.x(), pos.y(), pos.z());
        if (!level.noCollision(null, aabb) || !level.getEntities(null, aabb).isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverLevel, (ItemStack)itemStack, (Player)context.getPlayer());
            CameraStandEntity cameraStand = (CameraStandEntity)Exposure.EntityTypes.CAMERA_STAND.get().create(serverLevel, consumer, blockPos, MobSpawnType.SPAWN_EGG, true, true);
            if (cameraStand == null) {
                return InteractionResult.FAIL;
            }
            if (context.getPlayer() != null) {
                cameraStand.setOwnerPlayer(context.getPlayer());
            }
            cameraStand.moveTo(cameraStand.getX(), cameraStand.getY(), cameraStand.getZ(), 0.0f, 0.0f);
            serverLevel.addFreshEntityWithPassengers((Entity)cameraStand);
            cameraStand.playPlaceSound();
            cameraStand.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)context.getPlayer());
        }
        itemStack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public InteractionResult interactWithBoat(Player player, InteractionHand hand, Boat boat) {
        if (!player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (!(itemStack.getItem() instanceof CameraStandItem)) {
            return InteractionResult.PASS;
        }
        if (boat.getPassengers().size() >= 2) {
            return InteractionResult.PASS;
        }
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverLevel, (ItemStack)itemStack, (Player)player);
            CameraStandEntity cameraStand = (CameraStandEntity)Exposure.EntityTypes.CAMERA_STAND.get().create(serverLevel, consumer, boat.blockPosition(), MobSpawnType.SPAWN_EGG, true, true);
            if (cameraStand == null) {
                return InteractionResult.FAIL;
            }
            cameraStand.setOwnerPlayer(player);
            cameraStand.startRiding((Entity)boat);
            boat.positionRider((Entity)cameraStand);
            serverLevel.addFreshEntityWithPassengers((Entity)cameraStand);
            cameraStand.playPlaceSound();
            cameraStand.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)player);
            itemStack.shrink(1);
            player.setItemInHand(hand, itemStack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }
}

