/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands.exposure;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.CaptureStartDebugRGBS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ClearRenderingCacheS2CP;
import io.github.mortuusars.exposure.util.PointOfView;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraInHand;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.CaptureParameters;
import io.github.mortuusars.exposure.world.camera.capture.CaptureType;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.camera.frame.EntitiesInFrame;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.world.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class DebugCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").then(Commands.literal((String)"clear_rendering_cache").executes(DebugCommand::clearRenderingCache))).then(Commands.literal((String)"highlight_entities_in_frame").executes(DebugCommand::highlightEntitiesInFrame))).then(Commands.literal((String)"expose_rgb").executes(DebugCommand::exposeRGB))).then(Commands.literal((String)"chromatic_from_last_three_exposures").executes(DebugCommand::chromaticFromLastThreeExposures))).then(((LiteralArgumentBuilder)Commands.literal((String)"develop_film_in_hand").executes(context -> DebugCommand.developFilmInHand((CommandContext<CommandSourceStack>)context, true))).then(Commands.literal((String)"keep_original").executes(context -> DebugCommand.developFilmInHand((CommandContext<CommandSourceStack>)context, false))));
    }

    private static int clearRenderingCache(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack stack = (CommandSourceStack)context.getSource();
        ServerPlayer player = stack.getPlayerOrException();
        Packets.sendToClient(ClearRenderingCacheS2CP.INSTANCE, player);
        return 0;
    }

    private static int highlightEntitiesInFrame(CommandContext<CommandSourceStack> context) {
        ExposureServer.debugHighlightEntitiesInFrame = !ExposureServer.debugHighlightEntitiesInFrame;
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)("system.exposure.debug.highlight_entities_in_frame." + (ExposureServer.debugHighlightEntitiesInFrame ? "on" : "off"))).withStyle(ChatFormatting.RED));
        return 0;
    }

    private static int exposeRGB(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Item item;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        @Nullable CameraInHand cameraInHand = CameraInHand.find((CameraHolder)player);
        if (cameraInHand == null || cameraInHand.isEmpty() || !((item = ((Camera)cameraInHand).getItemStack().getItem()) instanceof CameraItem)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.exposure.debug.expose_rgb.fail.wrong_item"));
            return 0;
        }
        CameraItem cameraItem = (CameraItem)item;
        ItemStack cameraStack = ((Camera)cameraInHand).getItemStack();
        ArrayList<CaptureParameters> properties = new ArrayList<CaptureParameters>();
        for (int i = 0; i < 3; ++i) {
            ColorChannel channel = ColorChannel.values()[i];
            String exposureId = ExposureIdentifier.createId((Entity)player, channel.getSerializedName());
            CaptureParameters params = new CaptureParameters.Builder(exposureId).setCameraID(cameraInHand.getId()).setCameraHolder((CameraHolder)player).setFov(cameraItem.getFov(player.level(), cameraStack)).setCropFactor(cameraItem.getCropFactor()).setFilmProperties(cameraItem.getFilmProperties(cameraStack).withType(ExposureType.BLACK_AND_WHITE)).setChromaticChannel(channel).extraData(CaptureParameters.SHUTTER_SPEED, CameraSettings.SHUTTER_SPEED.getOrElse(cameraStack, ShutterSpeed.DEFAULT)).build();
            properties.add(params);
            PointOfView pov = cameraItem.getPointOfView((CameraHolder)player, cameraStack);
            double fov = cameraItem.getViewfinderFov(player.level(), cameraStack);
            List<BlockPos> positions = cameraItem.getPositionsInFrame((CameraHolder)player, pov, fov);
            List<LivingEntity> entities = EntitiesInFrame.get((CameraHolder)player, pov, fov);
            Frame frame = cameraItem.createFrame((CameraHolder)player, player.serverLevel(), cameraStack, params, positions, entities);
            Supplier<Component> msg = () -> {
                ItemStack photograph = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
                photograph.set(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frame);
                return Component.translatable((String)"command.exposure.debug.expose_rgb.success.captured", (Object[])new Object[]{channel.getSerializedName()}).append((Component)Component.literal((String)exposureId).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/exposure show id " + exposureId)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(photograph))).withUnderlined(Boolean.valueOf(true))));
            };
            ExposureServer.exposureRepository().expect(player, exposureId, (pl, id) -> ((CommandSourceStack)context.getSource()).sendSuccess(msg, true));
            ExposureServer.frameHistory().add((Entity)player, frame);
        }
        Packets.sendToClient(new CaptureStartDebugRGBS2CP(CaptureType.DEBUG_RGB, properties), player);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.exposure.debug.expose_rgb.success.capturing"), true);
        return 0;
    }

    private static int chromaticFromLastThreeExposures(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack stack = (CommandSourceStack)context.getSource();
        ServerPlayer player = stack.getPlayerOrException();
        List<Frame> allFrames = ExposureServer.frameHistory().getFramesOf((Entity)player).stream().filter(frame -> !frame.isChromatic()).toList();
        ArrayList<Frame> frames = new ArrayList<Frame>(allFrames.subList(Math.max(allFrames.size() - 3, 0), allFrames.size()));
        if (frames.size() < 3) {
            stack.sendFailure((Component)Component.translatable((String)"command.exposure.debug.chromatic_from_last_three.fail.not_enough_frames"));
            return 1;
        }
        try {
            Frame frame22;
            ChromaticSheetItem item = Exposure.Items.CHROMATIC_SHEET.get();
            ItemStack itemStack = new ItemStack((ItemLike)item);
            for (Frame frame22 : frames) {
                item.addLayer(itemStack, frame22);
            }
            ItemStack photographStack = item.combineIntoPhotograph(player, itemStack, false);
            frame22 = (Frame)photographStack.get(Exposure.DataComponents.PHOTOGRAPH_FRAME);
            Preconditions.checkState((frame22 != null ? 1 : 0) != 0, (Object)"Frame data cannot be empty after combining.");
            ExposureServer.frameHistory().add((Entity)player, frame22);
            Supplier<Component> msg = () -> {
                String exposureId = frame22.identifier().getId().orElseThrow();
                return Component.translatable((String)"command.exposure.debug.chromatic_from_last_three.success.created").append((Component)Component.literal((String)exposureId).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/exposure show latest")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(photographStack))).withUnderlined(Boolean.valueOf(true))));
            };
            stack.sendSuccess(msg, true);
        }
        catch (Exception e) {
            stack.sendFailure((Component)Component.translatable((String)"command.exposure.debug.chromatic_from_last_three.fail.error", (Object[])new Object[]{e.getMessage()}));
            Exposure.LOGGER.error("Failed to create chromatic exposure: ", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private static int developFilmInHand(CommandContext<CommandSourceStack> context, boolean replace) throws CommandSyntaxException {
        CommandSourceStack stack = (CommandSourceStack)context.getSource();
        ServerPlayer player = stack.getPlayerOrException();
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemInHand = player.getItemInHand(hand);
            Item item = itemInHand.getItem();
            if (!(item instanceof FilmRollItem)) continue;
            FilmRollItem filmRollItem = (FilmRollItem)item;
            DevelopedFilmItem itemType = filmRollItem.getType() == ExposureType.COLOR ? Exposure.Items.DEVELOPED_COLOR_FILM.get() : Exposure.Items.DEVELOPED_BLACK_AND_WHITE_FILM.get();
            ItemStack developedFilmStack = itemInHand.transmuteCopy((ItemLike)itemType);
            if (replace) {
                player.setItemInHand(hand, developedFilmStack);
            } else if (!player.addItem(developedFilmStack)) {
                player.drop(developedFilmStack, true, false);
            }
            stack.sendSuccess(() -> Component.translatable((String)"command.exposure.debug.develop.success", (Object[])new Object[]{itemInHand.getDisplayName()}), true);
            return 0;
        }
        stack.sendFailure((Component)Component.translatable((String)"command.exposure.debug.develop.fail.wrong_item"));
        return 1;
    }
}

