/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.task;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.capture.Capture;
import io.github.mortuusars.exposure.client.capture.CaptureShader;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.WrappedNativeImage;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.client.util.Shader;
import io.github.mortuusars.exposure.util.cycles.task.Result;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.renderer.PostChain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundScreenshotCaptureTask
extends Task<Result<Image>> {
    private static boolean capturing = false;
    @Nullable
    private static RenderTarget renderTarget = null;

    public static boolean isCapturing() {
        return capturing && renderTarget != null;
    }

    @NotNull
    public static RenderTarget getRenderTarget() {
        return Objects.requireNonNull(renderTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result<Image>> execute() {
        if (ExposureClient.shouldUseDirectCapture()) {
            Exposure.LOGGER.warn("BackgroundScreenshotCaptureMethod is used while incompatible mods are installed. Captured image most likely will not look as expected.");
        }
        Minecraft minecraft = Minecrft.get();
        renderTarget = new TextureTarget(minecraft.getWindow().getWidth(), minecraft.getWindow().getHeight(), true, Minecraft.ON_OSX);
        renderTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        renderTarget.clear(Minecraft.ON_OSX);
        try {
            capturing = true;
            minecraft.gameRenderer.setPanoramicMode(true);
            minecraft.gameRenderer.setRenderBlockOutline(false);
            minecraft.levelRenderer.graphicsChanged();
            renderTarget.bindWrite(false);
            minecraft.gameRenderer.renderLevel(minecraft.getTimer());
            this.applyShaderEffects(renderTarget);
            WrappedNativeImage image = new WrappedNativeImage(Screenshot.takeScreenshot((RenderTarget)renderTarget));
            CompletableFuture<Result<Image>> completableFuture = CompletableFuture.completedFuture(Result.success(image));
            return completableFuture;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Couldn't capture image: ", (Throwable)e);
            CompletableFuture<Result<Image>> completableFuture = CompletableFuture.completedFuture(Result.error(Capture.ERROR_FAILED_GENERIC));
            return completableFuture;
        }
        finally {
            minecraft.gameRenderer.setPanoramicMode(false);
            minecraft.gameRenderer.setRenderBlockOutline(true);
            renderTarget.destroyBuffers();
            renderTarget.unbindWrite();
            renderTarget = null;
            capturing = false;
            minecraft.levelRenderer.graphicsChanged();
            minecraft.getMainRenderTarget().bindWrite(true);
        }
    }

    private void applyShaderEffects(RenderTarget renderTarget) {
        @Nullable PostChain effect = Minecraft.getInstance().gameRenderer.currentEffect();
        if (effect != null && Minecraft.getInstance().gameRenderer.effectActive) {
            Shader.process(effect, renderTarget);
        }
        CaptureShader.process(renderTarget);
    }
}

