/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancements.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.advancements.predicate.EntityInFramePredicate;
import io.github.mortuusars.exposure.advancements.predicate.ExtraDataPredicate;
import io.github.mortuusars.exposure.advancements.predicate.ShutterSpeedPredicate;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SingleComponentItemPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record FramePredicate(Optional<ExposureIdentifier> identifier, Optional<String> type, Optional<String> photographer, Optional<ShutterSpeedPredicate> shutterSpeed, Optional<MinMaxBounds.Ints> focalLength, Optional<MinMaxBounds.Ints> lightLevel, Optional<MinMaxBounds.Ints> dayTime, Optional<MinMaxBounds.Ints> entitiesInFrameCount, Optional<List<EntityInFramePredicate>> entitiesInFrame, Optional<ExtraDataPredicate> extraData) implements SingleComponentItemPredicate<Frame>
{
    public static final Codec<FramePredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExposureIdentifier.CODEC.optionalFieldOf("identifier").forGetter(FramePredicate::identifier), (App)Codec.STRING.optionalFieldOf("type").forGetter(FramePredicate::type), (App)Codec.STRING.optionalFieldOf("photographer").forGetter(FramePredicate::photographer), (App)ShutterSpeedPredicate.CODEC.optionalFieldOf("shutter_speed").forGetter(FramePredicate::shutterSpeed), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("focal_length").forGetter(FramePredicate::focalLength), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("light_level").forGetter(FramePredicate::lightLevel), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("day_time").forGetter(FramePredicate::dayTime), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("entities_in_frame_count").forGetter(FramePredicate::entitiesInFrameCount), (App)EntityInFramePredicate.CODEC.listOf().optionalFieldOf("entities_in_frame").forGetter(FramePredicate::entitiesInFrame), (App)ExtraDataPredicate.CODEC.optionalFieldOf("extra_data").forGetter(FramePredicate::extraData)).apply((Applicative)instance, FramePredicate::new));

    @NotNull
    public DataComponentType<Frame> componentType() {
        return Exposure.DataComponents.PHOTOGRAPH_FRAME;
    }

    public boolean matches(ItemStack stack, Frame frame) {
        return this.matches(frame);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(Frame frame) {
        if (!this.identifier.isEmpty()) {
            if (!this.identifier.get().equals(frame.identifier())) return false;
        }
        if (!this.type.isEmpty()) {
            if (!this.type.get().equals(frame.type().getSerializedName())) return false;
        }
        if (!this.photographer.isEmpty()) {
            if (!this.photographer.get().equals(frame.photographer().name())) return false;
        }
        if (!this.shutterSpeed.isEmpty()) {
            if (!this.shutterSpeed.get().matches(frame.extraData().get(Frame.SHUTTER_SPEED))) return false;
        }
        if (!this.focalLength.isEmpty()) {
            if (frame.extraData().get(Frame.FOCAL_LENGTH).map(arg_0 -> ((MinMaxBounds.Ints)this.focalLength.get()).matches(arg_0)).orElse(false) == false) return false;
        }
        if (!this.lightLevel.isEmpty()) {
            if (frame.extraData().get(Frame.LIGHT_LEVEL).map(arg_0 -> ((MinMaxBounds.Ints)this.lightLevel.get()).matches(arg_0)).orElse(false) == false) return false;
        }
        if (!this.dayTime.isEmpty()) {
            if (frame.extraData().get(Frame.DAY_TIME).map(arg_0 -> ((MinMaxBounds.Ints)this.dayTime.get()).matches(arg_0)).orElse(false) == false) return false;
        }
        if (!this.entitiesInFrameCount.isEmpty()) {
            if (!this.entitiesInFrameCount.get().matches(frame.entitiesInFrame().size())) return false;
        }
        if (!this.entitiesInFrame.isEmpty()) {
            if (!this.entitiesInFrame.get().stream().allMatch(predicate -> predicate.matches(frame.entitiesInFrame()))) return false;
        }
        if (this.extraData.isEmpty()) return true;
        if (!this.extraData.get().matches((Tag)frame.extraData())) return false;
        return true;
    }
}

