/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.events;

import com.pedrorok.hypertube.core.travel.TravelManager;
import com.pedrorok.hypertube.network.packets.SyncPersistentDataPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="create_hypertube", bus=EventBusSubscriber.Bus.GAME)
public class PlayerSyncEvents {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerSyncEvents.syncAllStatesToPlayer(serverPlayer);
            PlayerSyncEvents.syncPlayerStateToAll((LivingEntity)serverPlayer, false);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TravelManager.finishTravel(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerSyncEvents.syncAllStatesToPlayer(serverPlayer);
            PlayerSyncEvents.syncPlayerStateToAll((LivingEntity)serverPlayer, false);
        }
    }

    private static void syncAllStatesToPlayer(ServerPlayer targetPlayer) {
        for (ServerPlayer otherPlayer : targetPlayer.getServer().getPlayerList().getPlayers()) {
            if (otherPlayer == targetPlayer || !TravelManager.hasHyperTubeData((Entity)otherPlayer)) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)targetPlayer, (CustomPacketPayload)SyncPersistentDataPacket.create((Entity)otherPlayer), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void syncPlayerStateToAll(LivingEntity sourcePlayer, boolean force) {
        if (!TravelManager.hasHyperTubeData((Entity)sourcePlayer) && !force) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)sourcePlayer, (CustomPacketPayload)SyncPersistentDataPacket.create((Entity)sourcePlayer), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

