/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.world.inventory;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mcreator.crazythings.init.CrazythingsModMenus;
import net.mcreator.crazythings.utils.Contact;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.mcreator.crazythings.world.inventory.CrazyPhoneDefaultScreenMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.SlotItemHandler;

public class CrazyPhoneContactsScreenMenu
extends CrazyPhoneDefaultScreenMenu {
    private static final String ADD_CONTACT_LABEL = "Ajouter un contact";
    private static final String CONTACT_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWRmZmYxYjNjNWQ4NWZlM2NkZDU2NTY4NjliYWEwZWFkZTVlNTNhY2E5ZDU2MTQyNzY0OGNjNzJmNWUyNWE5In19fQ==";
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private final int slotWidth = 18;
    private final int slotHeight = 18;
    private final List<Contact> contacts = new ArrayList<Contact>();

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public CrazyPhoneContactsScreenMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)CrazythingsModMenus.CRAZY_PHONE_CONTACTS_SCREEN.get(), id, inv, extraData);
        this.parseContactsFromBuffer(extraData);
        this.updateInventorySlots();
    }

    private void parseContactsFromBuffer(FriendlyByteBuf extraData) {
        int contactsSize = extraData.readInt();
        for (int i = 0; i < contactsSize; ++i) {
            String number = extraData.readUtf();
            String name = extraData.readUtf();
            String uuid = extraData.readUtf();
            String skin = extraData.readUtf();
            Contact contact = new Contact(number, name);
            if (!uuid.isEmpty()) {
                contact.setUuid(uuid);
            }
            if (!skin.isEmpty()) {
                contact.setSkin(skin);
            }
            this.contacts.add(contact);
        }
    }

    private void updateInventorySlots() {
        this.clearSlots();
        this.addContactHeads();
        this.addAddContactButton();
    }

    private void clearSlots() {
        for (int i = 0; i < 48; ++i) {
            this.internal.extractItem(i + 48, 64, false);
        }
        this.customSlots.clear();
    }

    private void addContactHeads() {
        int startX = 7;
        int startY = 11;
        int slotIndex = 0;
        for (int i = 0; i < this.contacts.size(); ++i) {
            int x = startX + i % 6 * 18;
            int y = startY + i / 6 * 18;
            Slot slot = this.createSlot(slotIndex + 48, x, y, this.contacts.get(i));
            this.customSlots.put(slotIndex, this.addSlot(slot));
            ItemStack item = CrazyPhoneHelper.createContactHead(this.contacts.get(i));
            this.internal.insertItem(slotIndex + 48, item, false);
            ++slotIndex;
        }
    }

    private Slot createSlot(int index, int x, int y, Contact contact) {
        return new SlotItemHandler(this, this.internal, index, x, y){

            public boolean mayPickup(Player player) {
                return false;
            }

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
            }

            public void set(ItemStack stack) {
            }
        };
    }

    private void addAddContactButton() {
        int slotIndex = this.contacts.size();
        int x = 7 + slotIndex % 6 * 18;
        int y = 11 + slotIndex / 6 * 18;
        SlotItemHandler slot = new SlotItemHandler(this, this.internal, slotIndex + 48, x, y){

            public boolean mayPickup(Player player) {
                return false;
            }

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
            }

            public void set(ItemStack stack) {
            }
        };
        this.customSlots.put(slotIndex, this.addSlot((Slot)slot));
        ItemStack head = this.createAddContactHead();
        this.internal.insertItem(slotIndex + 48, head, false);
    }

    public static boolean isAddContactHead(ItemStack stack) {
        return ADD_CONTACT_LABEL.equals(stack.getHoverName().getString());
    }

    private ItemStack createAddContactHead() {
        ItemStack head = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        MutableComponent displayName = Component.literal((String)ADD_CONTACT_LABEL).withStyle(style -> style.withColor(ChatFormatting.GOLD).withBold(Boolean.valueOf(true)));
        head.set(DataComponents.CUSTOM_NAME, (Object)displayName);
        GameProfile profile = new GameProfile(UUID.randomUUID(), "CustomHead");
        PropertyMap properties = profile.getProperties();
        properties.put((Object)"textures", (Object)new Property("textures", CONTACT_TEXTURE));
        ResolvableProfile resolvableProfile = new ResolvableProfile(profile);
        head.set(DataComponents.PROFILE, (Object)resolvableProfile);
        return head;
    }

    @Override
    public boolean stillValid(Player player) {
        return true;
    }

    @Override
    public ItemStack quickMoveStack(Player playerIn, int index) {
        return ItemStack.EMPTY;
    }

    @Override
    public void removed(Player playerIn) {
        super.removed(playerIn);
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }

    public void addContact(Contact contact) {
        this.contacts.add(contact);
        this.updateInventorySlots();
    }

    public void removeContact(int index) {
        if (index >= 0 && index < this.contacts.size()) {
            this.contacts.remove(index);
            this.updateInventorySlots();
        }
    }
}

