/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber
public class TickScheduler {
    private static final Map<Level, List<TickTask>> tickTasks = new HashMap<Level, List<TickTask>>();

    public static void schedule(Level level, int durationTicks, Runnable onTick, Runnable onFinish) {
        tickTasks.computeIfAbsent(level, l -> new ArrayList()).add(new TickTask(durationTicks, onTick, onFinish));
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        List<TickTask> tasks = tickTasks.get(level);
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        Iterator<TickTask> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            TickTask task = iterator.next();
            task.onTick.run();
            --task.remaining;
            if (task.remaining > 0) continue;
            task.onFinish.run();
            iterator.remove();
        }
    }

    private static class TickTask {
        int remaining;
        final Runnable onTick;
        final Runnable onFinish;

        public TickTask(int duration, Runnable onTick, Runnable onFinish) {
            this.remaining = duration;
            this.onTick = onTick;
            this.onFinish = onFinish;
        }
    }
}

